<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-23 16:49:01
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Store\\Order\\Order";

    /**
     * 创建订单
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Cmd\CreateOrderCmd $createOrderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->create($createOrderCmd);
    }
    /**
     * 使用礼品卡支付预付
     */
    public static function giftCardPrePay (int $id, float $giftCardMoney): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPrePay(["id" => $id, "giftCardMoney" => $giftCardMoney, ]);
    }
    /**
     * 根据订单id，查询用户是否使用了礼品卡，和礼品卡使用了多少
     */
    public static function giftCardPayInfo (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->giftCardPayInfo(["id" => $id, ]);
    }
    /**
     * 订单详情
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 通过核销取件码，获取零售自提订单核销相关的信息
     */
    public static function getOrderDetailByVerifyCode (string $code): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOrderDetailByVerifyCode(["code" => $code, ]);
    }
    /**
     * 门店零售订单列表
     */
    public static function storeOrderList (int $page, int $page_size, string $user_phone, string $paid_time_start, string $paid_time_end, string $user_name, string $order_no, string $pay_type, string $status, string $express_status, string $status_list, string $listType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->storeOrderList(["page" => $page, "page_size" => $page_size, "user_phone" => $user_phone, "paid_time_start" => $paid_time_start, "paid_time_end" => $paid_time_end, "user_name" => $user_name, "order_no" => $order_no, "pay_type" => $pay_type, "status" => $status, "express_status" => $express_status, "status_list" => $status_list, "listType" => $listType, ]);
    }
    /**
     * 门店定制订单列表-分页
     */
    public static function listPage (\Mainto\Bridge\Structs\ProjectRetail\Cmd\OrderListPageCmd $orderListPageCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listPage($orderListPageCmd);
    }
    /**
     * 修改流水支付方式
     */
    public static function changePayType (\Mainto\Bridge\Structs\ProjectRetail\Cmd\ChangePayTypeCmd $changePayTypeCmd): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->changePayType($changePayTypeCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}