<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-02 15:08:29
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Mall\\Order";

    /**
     * 创建零售商城订单或者门店定制订单
     *
     */
    public static function create (int $userId, string $userName, string $userPhone, string $userSex, string $userBirthday, float $money, float $originalMoney, float $realMoney, array $detail, int $inputStaffId, int $storeId, string $note, string $from = 'mall', string $source, string $isUrgent, array $couponIds, array $expressInfo, array $shopCartIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["userId" => $userId, "userName" => $userName, "userPhone" => $userPhone, "userSex" => $userSex, "userBirthday" => $userBirthday, "money" => $money, "originalMoney" => $originalMoney, "realMoney" => $realMoney, "detail" => $detail, "inputStaffId" => $inputStaffId, "storeId" => $storeId, "note" => $note, "from" => $from, "source" => $source, "isUrgent" => $isUrgent, "couponIds" => $couponIds, "expressInfo" => $expressInfo, "shopCartIds" => $shopCartIds, ]);
    }
    /**
     * 门店定制获取小程序下单逻辑参数数据
     *
     */
    public static function getOrderLogicParams (int $staffId, array $compositionDraftIds): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getOrderLogicParams(["staffId" => $staffId, "compositionDraftIds" => $compositionDraftIds, ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\GetOrderLogicParamsDTO[]"
        );
    }
    /**
     * 订单详情主表和子表不聚合
     *
     */
    public static function detailItemScattered (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemScattered(["id" => $id, ]);
    }
    /**
     * 订单详情主表和子表聚合
     *
     */
    public static function detailItemAssociative (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailItemAssociative(["id" => $id, ]);
    }
    /**
     * 订单列表
     *
     */
    public static function list (string $userPhone, string $orderNo, string $status, array $statusList, int $page = 1, int $pageSize = 100) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["userPhone" => $userPhone, "orderNo" => $orderNo, "status" => $status, "statusList" => $statusList, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 用户手动关闭订单——未支付状态
     *
     */
    public static function closeByUser (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->closeByUser(["id" => $id, ]);
    }
    /**
     * 用户订单——手动收货
     *
     */
    public static function receivedByUser (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->receivedByUser(["id" => $id, ]);
    }
    /**
     * 订单物流信息
     *
     */
    public static function orderLogistics (int $orderId, array $itemIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderLogistics(["orderId" => $orderId, "itemIds" => $itemIds, ]);
    }
    /**
     * 设置订单状态是支付确认中
     *
     */
    public static function orderStatusConfirming (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderStatusConfirming(["id" => $id, ]);
    }
    /**
     * 根据订单id保存用户邮寄地址
     *
     */
    public static function addOrderAddress (int $orderId, array $expressInfo): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addOrderAddress(["orderId" => $orderId, "expressInfo" => $expressInfo, ]);
    }
    /**
     * 设置订单完成支付-不走支付网关
     *
     */
    public static function setPaid (int $id, float $money, string $payType, string $paymentNo = '', string $certificate = '', string $paymentTime = ''): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->setPaid(["id" => $id, "money" => $money, "payType" => $payType, "paymentNo" => $paymentNo, "certificate" => $certificate, "paymentTime" => $paymentTime, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}