<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-02 15:08:29
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductOrder
 */
class ProductOrder {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Order\\ProductOrder";

    /**
     * 生产订单列表-分页
     *
     */
    public static function listWithPaginator (int $id, array $ids, string $orderNo, string $productOrderNo, string $status, int $orderId, array $orderIds, string $supplierCode, int $export, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->listWithPaginator(["id" => $id, "ids" => $ids, "orderNo" => $orderNo, "productOrderNo" => $productOrderNo, "status" => $status, "orderId" => $orderId, "orderIds" => $orderIds, "supplierCode" => $supplierCode, "export" => $export, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 生产订单导出-直接通过接口
     *
     */
    public static function productOrderListExportAdd (array $ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOrderListExportAdd(["ids" => $ids, ]);
    }
    /**
     * 生产订单图片导出
     *
     */
    public static function productOrderImagesExportAdd (array $ids, string $imageType = 'complete'): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOrderImagesExportAdd(["ids" => $ids, "imageType" => $imageType, ]);
    }
    /**
     * 单个生产订单批量绑定快递单号
     *
     */
    public static function createLogistics (string $productOrderNo, array $logisticsNos) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createLogistics(["productOrderNo" => $productOrderNo, "logisticsNos" => $logisticsNos, ]);
    }
    /**
     * 修改生产单备注
     *
     */
    public static function editProductOrderNote (int $productOrderId, string $note) {
        return RpcClass::getClass(self::$serviceName, self::$className)->editProductOrderNote(["productOrderId" => $productOrderId, "note" => $note, ]);
    }
    /**
     * 多个生产订单批量绑定快递单号
     *
     */
    public static function batchCreateLogistics (array $data): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchCreateLogistics(["data" => $data, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}