<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-02-02 16:53:58
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SellChannel
 */
class SellChannel {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\SellChannel";

    /**
     * 创建渠道
     *
     */
    public static function create (string $name, string $code, int $isStoreSell): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "code" => $code, "isStoreSell" => $isStoreSell, ]);
    }
    /**
     * 渠道列表
     *
     */
    public static function list (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list();
    }
    /**
     * 复制渠道商品sku
     *
     */
    public static function copyProductSku (int $sellChannelProductSkuId, string $sellChannelSkuName, string $sellChannelSkuImage, float $sellPrice, float $settlementPrice): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->copyProductSku(["sellChannelProductSkuId" => $sellChannelProductSkuId, "sellChannelSkuName" => $sellChannelSkuName, "sellChannelSkuImage" => $sellChannelSkuImage, "sellPrice" => $sellPrice, "settlementPrice" => $settlementPrice, ]);
    }
    /**
     * 修改渠道商品sku
     *
     */
    public static function updateProductSku (int $sellChannelProductSkuId, string $sellChannelCode, string $sellChannelSkuName, string $sellChannelSkuImage, string $outSkuCode, float $sellPrice, float $settlementPrice): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProductSku(["sellChannelProductSkuId" => $sellChannelProductSkuId, "sellChannelCode" => $sellChannelCode, "sellChannelSkuName" => $sellChannelSkuName, "sellChannelSkuImage" => $sellChannelSkuImage, "outSkuCode" => $outSkuCode, "sellPrice" => $sellPrice, "settlementPrice" => $settlementPrice, ]);
    }
    /**
     * 批量销售渠道上架productSku
     *
     */
    public static function shelveProductSku (array $sellChannelProductSkuIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->shelveProductSku(["sellChannelProductSkuIds" => $sellChannelProductSkuIds, ]);
    }
    /**
     * 批量销售渠道下架productSku
     *
     */
    public static function unshelveProductSku (array $sellChannelProductSkuIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->unshelveProductSku(["sellChannelProductSkuIds" => $sellChannelProductSkuIds, ]);
    }
    /**
     * 销售渠道productSku列表 - 分页
     *
     */
    public static function productSkuListWithoutPaginate (array $ids, int $sellChannelId, int $sellChannelProductId, array $categoryIds, string $skuName, bool $isOnlyShelveUp = false, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithoutPaginate(["ids" => $ids, "sellChannelId" => $sellChannelId, "sellChannelProductId" => $sellChannelProductId, "categoryIds" => $categoryIds, "skuName" => $skuName, "isOnlyShelveUp" => $isOnlyShelveUp, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 销售渠道productSku列表 - 不分页
     *
     */
    public static function productSkuList (array $ids, int $sellChannelId, int $sellChannelProductId, array $categoryIds, string $skuName, bool $isOnlyShelveUp = false): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["ids" => $ids, "sellChannelId" => $sellChannelId, "sellChannelProductId" => $sellChannelProductId, "categoryIds" => $categoryIds, "skuName" => $skuName, "isOnlyShelveUp" => $isOnlyShelveUp, ]);
    }
    /**
     * 销售渠道product列表 - 分页
     *
     */
    public static function productListWithoutPaginate (int $sellChannelId = 5, array $categoryIds, string $productName, int $groupId, string $status, int $page = 1, int $pageSize = 100): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productListWithoutPaginate(["sellChannelId" => $sellChannelId, "categoryIds" => $categoryIds, "productName" => $productName, "groupId" => $groupId, "status" => $status, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 产品搜索查询-不分页
     *
     */
    public static function productList (array $ids, int $type = 4, string $name, int $groupId, int $sellChannelId = 5, bool $isOnlyShelveUp = false): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productList(["ids" => $ids, "type" => $type, "name" => $name, "groupId" => $groupId, "sellChannelId" => $sellChannelId, "isOnlyShelveUp" => $isOnlyShelveUp, ]);
    }
    /**
     * 销售渠道product更新
     *
     */
    public static function updateProduct (int $sellChannelProductId, string $name, array $newMainImage, array $bannerUrl, array $descriptionUrl, string $status): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateProduct(["sellChannelProductId" => $sellChannelProductId, "name" => $name, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "status" => $status, ]);
    }
    /**
     * 批量销售渠道上架product
     *
     */
    public static function shelveProduct (int $sellChannelProductId, array $sellChannelProductIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->shelveProduct(["sellChannelProductId" => $sellChannelProductId, "sellChannelProductIds" => $sellChannelProductIds, ]);
    }
    /**
     * 批量销售渠道下架product
     *
     */
    public static function unShelveProduct (int $sellChannelProductId, array $sellChannelProductIds): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->unShelveProduct(["sellChannelProductId" => $sellChannelProductId, "sellChannelProductIds" => $sellChannelProductIds, ]);
    }
    /**
     * 根据产品id获取单个product
     *
     */
    public static function getProductById (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductById(["id" => $id, ]);
    }
    /**
     * 手动批量更新sku信息
     *
     */
    public static function manualBatchUpdateSku (array $data): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->manualBatchUpdateSku(["data" => $data, ]);
    }
    /**
     * 批量设置productSku的sellPrice
     *
     */
    public static function batchUpdateProductSkuSellPrice (array $productSkus): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateProductSkuSellPrice(["productSkus" => $productSkus, ]);
    }
    /**
     * 导出某个渠道所有的sku简略信息
     *
     */
    public static function exportAdd (string $template_id, array $params): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->exportAdd(["template_id" => $template_id, "params" => $params, ]);
    }
    /**
     * 批量设置赠品Sku
     *
     */
    public static function batchUpdateGiftProductSku (array $skuIds, int $discountId, string $startTime, string $endTime, array $storeIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateGiftProductSku(["skuIds" => $skuIds, "discountId" => $discountId, "startTime" => $startTime, "endTime" => $endTime, "storeIds" => $storeIds, ]);
    }
    /**
     * 获取某渠道下所有的skuIds-不分页
     *
     */
    public static function getSkuIdsBySellChannelId (int $sellChannelId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getSkuIdsBySellChannelId(["sellChannelId" => $sellChannelId, ]);
    }
    /**
     * 批量更新渠道sku图片
     *
     */
    public static function batchUpdateSkuImageBySkuIds (array $updateProductSkuImages): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchUpdateSkuImageBySkuIds(["updateProductSkuImages" => $updateProductSkuImages, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}