<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAddedProductByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $params)
 * @method updateAddedProductByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $params)
 * @method addedProductSkuBatchUpdateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $params)
 * @method bindAddedSkuListByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $params)
 * @method bindAddedSkuByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuCmd $params)
 * @method addedServiceCategoryListByParams(array $params)
 * @method addedProductWithPaginatorByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductsWithPaginatorCmd $params)
 * @method addedProductSkuListByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuListCmd $params)
 * @method addedProductDetailByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $params)
 * @method deleteAddedProductByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $params)
 * @method deleteAddedProductSkuByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\DeleteAddedProductSkuCmd $params)
 * @method productSkuPricePendingListByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\SearchPricePendingCmd $params)
 * @method resubmitPricePendingByParams(array $params)
 */
class ProductV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建增值服务产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $createAddedProductCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\CreateAddedProductDTO
     */
    public static function createAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $createAddedProductCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createAddedProduct($createAddedProductCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\CreateAddedProductDTO"
        );
    }


    /**
     * 更新增值服务产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $updateAddedProductCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $updateAddedProductCmd) {
        return self::getClass()->updateAddedProduct($updateAddedProductCmd);
    }


    /**
     * 批量创建增值服务产品sku
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $addedProductSkuBatchUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addedProductSkuBatchUpdate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $addedProductSkuBatchUpdateCmd) {
        return self::getClass()->addedProductSkuBatchUpdate($addedProductSkuBatchUpdateCmd);
    }


    /**
     * 查看增值服务产品sku列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $bindAddedSkuListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\BindAddedSkuListDTO
     */
    public static function bindAddedSkuList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $bindAddedSkuListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindAddedSkuList($bindAddedSkuListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\BindAddedSkuListDTO"
        );
    }


    /**
     * 产品sku绑定/解绑增值服务
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuCmd $bindAddedSkuCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bindAddedSku (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuCmd $bindAddedSkuCmd) {
        return self::getClass()->bindAddedSku($bindAddedSkuCmd);
    }


    /**
     * 查看增值服务分类列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedServiceCategoryListDTO[]
     */
    public static function addedServiceCategoryList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addedServiceCategoryList(),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedServiceCategoryListDTO[]"
        );
    }

    /**
     * 查看增值服务列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductsWithPaginatorCmd $addedProductWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductsWithPaginatorDTO
     */
    public static function addedProductWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductsWithPaginatorCmd $addedProductWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addedProductWithPaginator($addedProductWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductsWithPaginatorDTO"
        );
    }


    /**
     * 查看当前增值服务下sku列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuListCmd $addedProductSkuListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedSkuDTO[]
     */
    public static function addedProductSkuList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuListCmd $addedProductSkuListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addedProductSkuList($addedProductSkuListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedSkuDTO[]"
        );
    }


    /**
     * 查看增值服务详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $addedProductDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductDTO
     */
    public static function addedProductDetail (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $addedProductDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->addedProductDetail($addedProductDetailCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\AddedProductDTO"
        );
    }


    /**
     * 删除增值服务spu
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $addedProductDetailCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductDetailCmd $addedProductDetailCmd) {
        return self::getClass()->deleteAddedProduct($addedProductDetailCmd);
    }


    /**
     * 删除增值服务sku
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\DeleteAddedProductSkuCmd $deleteAddedProductSkuCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteAddedProductSku (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\DeleteAddedProductSkuCmd $deleteAddedProductSkuCmd) {
        return self::getClass()->deleteAddedProductSku($deleteAddedProductSkuCmd);
    }


    /**
     * sku价格审批列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\SearchPricePendingCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuPricePendingList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\SearchPricePendingCmd $cmd) {
        return self::getClass()->productSkuPricePendingList($cmd);
    }


    /**
     * 重新提交价格审批
     *
     * @param  int $productSkuPricePendingId 审批记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resubmitPricePending (int $productSkuPricePendingId) {
        return self::getClass()->resubmitPricePending([
            "productSkuPricePendingId" => $productSkuPricePendingId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\ProductV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\ProductV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}