<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-11 11:32:53
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Supplier
 */
class Supplier {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Supplier";

    /**
     * 创建供应商
     *
     */
    public static function create (string $name, int $deliveryCycle, string $code, string $domain, string $remark): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["name" => $name, "deliveryCycle" => $deliveryCycle, "code" => $code, "domain" => $domain, "remark" => $remark, ]);
    }
    /**
     * 修改供应商
     *
     */
    public static function update (int $id, string $name, int $deliveryCycle, string $remark): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "name" => $name, "deliveryCycle" => $deliveryCycle, "remark" => $remark, ]);
    }
    /**
     * 供应商列表-分页
     *
     */
    public static function list (string $name, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 删除供应商
     *
     */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id, ]);
    }
    /**
     * 所有供应商[不分页]
     *
     */
    public static function all (string $name): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->all(["name" => $name, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}