<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-11 11:32:53
 */
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectRetail";

    private static string $className = "Bms\\Product\\Product";

    /**
     * 手动创建任务字符码
     *
     */
    public static function createRandom (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createRandom();
    }
    /**
     * 创建产品
     *
     */
    public static function create (int $type, int $categoryId, string $name, array $newMainImage, array $bannerUrl, array $descriptionUrl, int $needCheckStock): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->create(["type" => $type, "categoryId" => $categoryId, "name" => $name, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "needCheckStock" => $needCheckStock, ]);
    }
    /**
     * 更新产品
     *
     */
    public static function update (int $id, int $type, int $categoryId, int $groupId, string $name, array $newMainImage, array $bannerUrl, array $descriptionUrl, bool $needCheckStock): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "type" => $type, "categoryId" => $categoryId, "groupId" => $groupId, "name" => $name, "newMainImage" => $newMainImage, "bannerUrl" => $bannerUrl, "descriptionUrl" => $descriptionUrl, "needCheckStock" => $needCheckStock, ]);
    }
    /**
     * 批量创建productSku
     *
     */
    public static function productSkuBatchCreate (int $productId, int $type, int $supplierId, array $productSku, array $productExtendMetric): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuBatchCreate(["productId" => $productId, "type" => $type, "supplierId" => $supplierId, "productSku" => $productSku, "productExtendMetric" => $productExtendMetric, ]);
    }
    /**
     * 批量更新productSku
     *
     */
    public static function productSkuBatchUpdate (int $productId, int $type, int $supplierId, array $productSku, array $productExtendMetric): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuBatchUpdate(["productId" => $productId, "type" => $type, "supplierId" => $supplierId, "productSku" => $productSku, "productExtendMetric" => $productExtendMetric, ]);
    }
    /**
     * 上架product
     *
     */
    public static function productOn (int $productId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOn(["productId" => $productId, ]);
    }
    /**
     * 下架product
     *
     */
    public static function productOff (int $productId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productOff(["productId" => $productId, ]);
    }
    /**
     * 上架productSku
     *
     */
    public static function productSkuShelve (int $productSkuId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuShelve(["productSkuId" => $productSkuId, ]);
    }
    /**
     * 下架productSku
     *
     */
    public static function productSkuUnshelve (int $productSkuId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuUnshelve(["productSkuId" => $productSkuId, ]);
    }
    /**
     * product停用
     *
     */
    public static function productDisable (int $productId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productDisable(["productId" => $productId, ]);
    }
    /**
     * product启用
     *
     */
    public static function productEnable (int $productId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productEnable(["productId" => $productId, ]);
    }
    /**
     * productSku停用
     *
     */
    public static function productSkuDisable (int $productSkuId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuDisable(["productSkuId" => $productSkuId, ]);
    }
    /**
     * productSku启用
     *
     */
    public static function productSkuEnable (int $productSkuId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuEnable(["productSkuId" => $productSkuId, ]);
    }
    /**
     * 产品详情-不带sku
     *
     */
    public static function detail (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detail(["id" => $id, ]);
    }
    /**
     * 产品详情-附带sku
     *
     */
    public static function detailWithSku (int $id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->detailWithSku(["id" => $id, ]);
    }
    /**
     * 根据productId获取下面所有的productSkus
     *
     */
    public static function getProductSkusByProductId (int $productId, bool $isShowDisable): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductSkusByProductId(["productId" => $productId, "isShowDisable" => $isShowDisable, ]);
    }
    /**
     * 产品搜索查询-不分页
     *
     */
    public static function allList (int $type, int $groupId, array $productIds, string $name): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->allList(["type" => $type, "groupId" => $groupId, "productIds" => $productIds, "name" => $name, ]);
    }
    /**
     * 获取productSku-分页
     *
     */
    public static function productSkuList (int $id, array $ids, int $productId, array $productIds, array $status, string $skuName, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuList(["id" => $id, "ids" => $ids, "productId" => $productId, "productIds" => $productIds, "status" => $status, "skuName" => $skuName, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 上传sku模版psd
     *
     */
    public static function updateCustomizedTemplate (int $skuId, string $templatePath): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateCustomizedTemplate(["skuId" => $skuId, "templatePath" => $templatePath, ]);
    }
    /**
     * sku模版回调
     *
     */
    public static function callbackOutSkuTemplate (string $task_id, string $type, string $out_path, string $status, string $fail_reason): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackOutSkuTemplate(["task_id" => $task_id, "type" => $type, "out_path" => $out_path, "status" => $status, "fail_reason" => $fail_reason, ]);
    }
    /**
     * 用户作品回调
     *
     */
    public static function callbackProductOrderItem (string $task_id, string $type, string $out_path, string $status, string $fail_reason): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->callbackProductOrderItem(["task_id" => $task_id, "type" => $type, "out_path" => $out_path, "status" => $status, "fail_reason" => $fail_reason, ]);
    }
    /**
     * 产品搜索列表-各种条件的复杂查询
     *
     */
    public static function searchProductList (int $type, array $types, int $groupId, string $name, int $categoryId, array $categoryIds, bool $isShowDisable, array $status, string $startAt, string $endAt, int $needCheckStock, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchProductList(["type" => $type, "types" => $types, "groupId" => $groupId, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "isShowDisable" => $isShowDisable, "status" => $status, "startAt" => $startAt, "endAt" => $endAt, "needCheckStock" => $needCheckStock, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 查询搜索列表-各种条件的复杂查询，只查询在供应链有数据的product
     *
     */
    public static function searchMaterialList (int $type, array $types, int $groupId, string $name, int $categoryId, array $categoryIds, bool $isShowDisable, array $status, string $startAt, string $endAt, int $needCheckStock, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->searchMaterialList(["type" => $type, "types" => $types, "groupId" => $groupId, "name" => $name, "categoryId" => $categoryId, "categoryIds" => $categoryIds, "isShowDisable" => $isShowDisable, "status" => $status, "startAt" => $startAt, "endAt" => $endAt, "needCheckStock" => $needCheckStock, "page" => $page, "pageSize" => $pageSize, ]);
    }
    /**
     * 商品sku信息导入
     *
     */
    public static function productSkuImport (array $data): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuImport(["data" => $data, ]);
    }
    /**
     * 商品sku信息导出
     *
     */
    public static function productSkuExportAdd (string $template_id, array $params): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuExportAdd(["template_id" => $template_id, "params" => $params, ]);
    }
    /**
     * 零售POS收银-productSku列表，该接口单独只给BMS端活动试算使用
     *
     */
    public static function productSkuListWithPaginate (int $storeId, array $categoryIds, string $skuName, string $skuCode, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productSkuListWithPaginate(["storeId" => $storeId, "categoryIds" => $categoryIds, "skuName" => $skuName, "skuCode" => $skuCode, "page" => $page, "pageSize" => $pageSize, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    mixed
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}