<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Cmd\CreateOrderCmd $params)
 * @method giftCardPrePayByParams(array $params)
 * @method giftCardPayInfoByParams(array $params)
 * @method detailByParams(array $params)
 * @method getOrderDetailByVerifyCodeByParams(array $params)
 * @method storeOrderListByParams(array $params)
 * @method listPageByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Cmd\OrderListPageCmd $params)
 * @method changePayTypeByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Cmd\ChangePayTypeCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Cmd\CreateOrderCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Cmd\CreateOrderCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 使用礼品卡支付预付
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $giftCardMoney 礼品卡支付金额 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function giftCardPrePay (int $id, float $giftCardMoney) {
        return self::getClass()->giftCardPrePay([
            "id" => $id,
            "giftCardMoney" => $giftCardMoney,
        ]);
    }

    /**
     * 根据订单id，查询用户是否使用了礼品卡，和礼品卡使用了多少
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function giftCardPayInfo (int $id) {
        return self::getClass()->giftCardPayInfo([
            "id" => $id,
        ]);
    }

    /**
     * 订单详情
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 通过核销取件码，获取零售自提订单核销相关的信息
     *
     * @support  string $code 自提订单提货码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOrderDetailByVerifyCode () {
        return self::getClass()->getOrderDetailByVerifyCode([
        ]);
    }

    /**
     * 门店零售订单列表
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 页内条数 [ require false ]
     * @support  string $user_phone 电话号码 [ require false ]
     * @support  string $paid_time_start 支付起始时间 [ require false ]
     * @support  string $paid_time_end 支付结束时间 [ require false ]
     * @support  string $user_name 用户姓名 [ require false ]
     * @support  string $order_no 订单号 [ require false ]
     * @support  string $pay_type 支付方式 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $express_status 自提状态 [ require false ]
     * @support  string $status_list 状态列表 [ require false ]
     * @support  string $listType 查询列表类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function storeOrderList () {
        return self::getClass()->storeOrderList([
        ]);
    }

    /**
     * 门店定制订单列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Cmd\OrderListPageCmd $orderListPageCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function listPage (\Mainto\Bridge\Structs\ProjectRetail\Cmd\OrderListPageCmd $orderListPageCmd) {
        return self::getClass()->listPage($orderListPageCmd);
    }


    /**
     * 修改流水支付方式
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Cmd\ChangePayTypeCmd $cmd
     * @throws  \Exception
     * @return  string
     */
    public static function changePayType (\Mainto\Bridge\Structs\ProjectRetail\Cmd\ChangePayTypeCmd $cmd) {
        return self::getClass()->changePayType($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Store\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Store\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}