<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method copyProductSkuByParams(array $params)
 * @method updateProductSkuByParams(array $params)
 * @method shelveProductSkuByParams(array $params)
 * @method unshelveProductSkuByParams(array $params)
 * @method productSkuListWithoutPaginateByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method productListWithoutPaginateByParams(array $params)
 * @method productListByParams(array $params)
 * @method updateProductByParams(array $params)
 * @method shelveProductByParams(array $params)
 * @method unShelveProductByParams(array $params)
 * @method getProductByIdByParams(array $params)
 * @method manualBatchUpdateSkuByParams(array $params)
 * @method batchUpdateProductSkuSellPriceByParams(array $params)
 * @method exportAddByParams(array $params)
 * @method batchUpdateGiftProductSkuByParams(array $params)
 * @method getSkuIdsBySellChannelIdByParams(array $params)
 * @method batchUpdateSkuImageBySkuIdsByParams(array $params)
 */
class SellChannel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建渠道
     *
     * @support  string $name 渠道name [ require true ]
     * @support  string $code 渠道code [ require false ]
     * @support  int $isStoreSell 是否门店售卖 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 渠道列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 复制渠道商品sku
     *
     * @support  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @support  string $sellChannelSkuName 拍摄自定义的productSkuName别名 [ require false ]
     * @support  string $sellChannelSkuImage 拍摄自定义的productSkuImage图片 [ require false ]
     * @support  float $sellPrice 售价 [ require false ]
     * @support  float $settlementPrice 结算价格 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function copyProductSku () {
        return self::getClass()->copyProductSku([
        ]);
    }

    /**
     * 修改渠道商品sku
     *
     * @support  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @support  string $sellChannelCode 销售渠道类型：用于检验参数 [ require true ]
     * @support  string $sellChannelSkuName 拍摄自定义的productSkuName别名 [ require false ]
     * @support  string $sellChannelSkuImage 拍摄自定义的productSkuImage图片 [ require false ]
     * @support  string $outSkuCode 天猫有赞关联的 外部编码 [ require false ]
     * @support  float $sellPrice 售价 [ require false ]
     * @support  float $settlementPrice 结算价格 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProductSku () {
        return self::getClass()->updateProductSku([
        ]);
    }

    /**
     * 批量销售渠道上架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->shelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 批量销售渠道下架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unshelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->unshelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 销售渠道productSku列表 - 分页
     *
     * @support  array $ids 渠道skuIds数组 [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  int $sellChannelProductId 销售渠道productId [ require false ]
     * @support  array $categoryIds 销售渠道categoryIds数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuListWithoutPaginate () {
        return self::getClass()->productSkuListWithoutPaginate([
        ]);
    }

    /**
     * 销售渠道productSku列表 - 不分页
     *
     * @support  array $ids 渠道skuIds数组 [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  int $sellChannelProductId 销售渠道productId [ require false ]
     * @support  array $categoryIds 销售渠道categoryIds数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList([
        ]);
    }

    /**
     * 销售渠道product列表 - 分页
     *
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  array $categoryIds 销售渠道categoryIds数组 [ require false ]
     * @support  string $productName 销售渠道productName [ require false ]
     * @support  int $groupId 分组id [ require false ]
     * @support  string $status 商品状态[上架：shelve;下架：unshelve；]不传为全部 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productListWithoutPaginate () {
        return self::getClass()->productListWithoutPaginate([
        ]);
    }

    /**
     * 产品搜索查询-不分页
     *
     * @support  array $ids 渠道productId数组 [ require false ]
     * @support  int $type 1零售商品,2陈列商品,3定制商品,4商城定制商品 [ require false ]
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $groupId 商品分组id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function productList () {
        return self::getClass()->productList([
        ]);
    }

    /**
     * 销售渠道product更新
     *
     * @support  int $sellChannelProductId 渠道商品productId [ require true ]
     * @support  string $name 产品名称 [ require false ]
     * @support  array $newMainImage 商品主图复杂对象 [ require false ]
     * @support  array $bannerUrl 商品banner图复杂对象 [ require false ]
     * @support  array $descriptionUrl 商品描述图对象 [ require false ]
     * @support  string $status 状态：shelve上架，unshelve下架 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProduct () {
        return self::getClass()->updateProduct([
        ]);
    }

    /**
     * 批量销售渠道上架product
     *
     * @support  int $sellChannelProductId 销售渠道productId [ require false ]
     * @support  array $sellChannelProductIds 销售渠道productIds数组 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelveProduct () {
        return self::getClass()->shelveProduct([
        ]);
    }

    /**
     * 批量销售渠道下架product
     *
     * @support  int $sellChannelProductId 销售渠道productId [ require false ]
     * @support  array $sellChannelProductIds 销售渠道productIds数组 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unShelveProduct () {
        return self::getClass()->unShelveProduct([
        ]);
    }

    /**
     * 根据产品id获取单个product
     *
     * @param  int $id 渠道商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductById (int $id) {
        return self::getClass()->getProductById([
            "id" => $id,
        ]);
    }

    /**
     * 手动批量更新sku信息
     *
     * @support  array $data 修改数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualBatchUpdateSku () {
        return self::getClass()->manualBatchUpdateSku([
        ]);
    }

    /**
     * 批量设置productSku的sellPrice
     *
     * @support  array $productSkus 修改数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdateProductSkuSellPrice () {
        return self::getClass()->batchUpdateProductSkuSellPrice([
        ]);
    }

    /**
     * 导出某个渠道所有的sku简略信息
     *
     * @support  string $template_id 模板id:retail_batch_set_product_sku_sell_price_template [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportAdd () {
        return self::getClass()->exportAdd([
        ]);
    }

    /**
     * 批量设置赠品Sku
     *
     * @support  array $skuIds 渠道skuids [ require true ]
     * @support  int $discountId 当前更新活动id [ require false ]
     * @support  string $startTime 开始时间 [ require true ]
     * @support  string $endTime 结束时间 [ require true ]
     * @support  array $storeIds 渠道skuids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdateGiftProductSku () {
        return self::getClass()->batchUpdateGiftProductSku([
        ]);
    }

    /**
     * 获取某渠道下所有的skuIds-不分页
     *
     * @param  int $sellChannelId 渠道sellChannelId,1零售，2拍摄，3天猫，4有赞，5定制商城，6赠品 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuIdsBySellChannelId (int $sellChannelId) {
        return self::getClass()->getSkuIdsBySellChannelId([
            "sellChannelId" => $sellChannelId,
        ]);
    }

    /**
     * 批量更新渠道sku图片
     *
     * @support  array $updateProductSkuImages sku图片上传数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdateSkuImageBySkuIds () {
        return self::getClass()->batchUpdateSkuImageBySkuIds([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\SellChannel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\SellChannel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}