<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method stopByParams(array $params)
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method checkProductSkuImportByParams(array $params)
 * @method exportAddByParams(array $params)
 */
class AdjustPrice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建调价单
     *
     * @support  int $recordId 调价活动备案id [ require true ]
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $description 调价单活动描述 [ require false ]
     * @support  int $sellChannelId productSku的渠道 [ require true ]
     * @support  array $storeGroupIds 参与门店组id [ require false ]
     * @support  array $storeIds 参与门店id数组 [ require true ]
     * @support  array $productSkus productSku调价信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑调价单
     *
     * @support  int $id 调价单id [ require true ]
     * @support  int $recordId 调价活动备案id [ require true ]
     * @support  string $name 调价单名称 [ require true ]
     * @support  string $startAt 开始时间 [ require true ]
     * @support  string $endAt 结束时间 [ require true ]
     * @support  string $description 调价单活动描述 [ require false ]
     * @support  int $sellChannelId productSku的渠道 [ require true ]
     * @support  array $storeGroupIds 参与门店组id [ require false ]
     * @support  array $storeIds 参与门店id数组 [ require true ]
     * @support  array $productSkus productSku调价信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 终止调价单
     *
     * @support  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stop () {
        return self::getClass()->stop([
        ]);
    }

    /**
     * 调价单详情
     *
     * @param  int $id 调价单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调价单列表
     *
     * @support  int $id 调价单id [ require false ]
     * @support  string $name 调价单名称 [ require false ]
     * @support  string $status 调价单状态:not_start未开始,in_progress进行中,ended已结束 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 校验创建条件单时批量导入的productSku数据合法性
     *
     * @param  array $productSkus 需要被校验的productSkus [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkProductSkuImport (array $productSkus) {
        return self::getClass()->checkProductSkuImport([
            "productSkus" => $productSkus,
        ]);
    }

    /**
     * 导出某个渠道所有的sku简略信息
     *
     * @support  string $template_id 模板id:retail_adjust_price_product_sku_template [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportAdd () {
        return self::getClass()->exportAdd([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\AdjustPrice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\AdjustPrice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}