<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method modifyOrderStaffIdByOrderNoByParams(array $params)
 * @method detailItemScatteredByParams(array $params)
 * @method storeDetailItemsByParams(array $params)
 * @method detailItemAssociativeByParams(array $params)
 * @method listByParams(array $params)
 * @method storeListByParams(array $params)
 * @method timingReceivedOrderByParams(array $params)
 * @method orderListExportAddByParams(array $params)
 * @method detailByParams(array $params)
 * @method manualCreateProductOrderByParams(array $params)
 * @method manualChangeOrderStatusByParams(array $params)
 * @method getOmsExceptionOrderListByParams(array $params)
 * @method changePayTypeByParams(array $params)
 * @method addOrderAddressByParams(array $params)
 * @method finishExpressByParams(array $params)
 * @method setPaidByParams(array $params)
 * @method dingNotifyStaffEffectByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据订单编号修改售出伙伴id
     *
     * @support  string $orderNo 零售订单号 [ require true ]
     * @support  int $inputStaffId 售出伙伴id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyOrderStaffIdByOrderNo () {
        return self::getClass()->modifyOrderStaffIdByOrderNo([
        ]);
    }

    /**
     * 商城订单-订单详情主表和子表不聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemScattered () {
        return self::getClass()->detailItemScattered([
        ]);
    }

    /**
     * 门店商城订单-订单详情
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeDetailItems () {
        return self::getClass()->storeDetailItems([
        ]);
    }

    /**
     * 商城订单-订单详情主表和子表聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemAssociative () {
        return self::getClass()->detailItemAssociative([
        ]);
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $productOrderNo 生产单号 [ require false ]
     * @support  string $userName 用户名 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $source 下单方式来源：定制平台:customPlatform，门店:offlineSales [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $productOrderNo 生产单号 [ require false ]
     * @support  string $userName 用户名 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $storeId 门店ID [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function storeList () {
        return self::getClass()->storeList([
        ]);
    }

    /**
     * 后台手动收货
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function timingReceivedOrder () {
        return self::getClass()->timingReceivedOrder([
        ]);
    }

    /**
     * 订单列表导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数[userPhone:电话号码;orderNo:订单号;createTimeStart:创建开始时间;createTimeEnd:创建结束时间;status:状态;inputStaffId:录入人伙伴ID] [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function orderListExportAdd () {
        return self::getClass()->orderListExportAdd([
        ]);
    }

    /**
     * 零售订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 手动创建生成单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualCreateProductOrder (int $id) {
        return self::getClass()->manualCreateProductOrder([
            "id" => $id,
        ]);
    }

    /**
     * 零售订单详情
     *
     * @support  string $status 状态;[生产中:produced;待收货:shipped;] [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  int $orderItemId 订单子单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualChangeOrderStatus () {
        return self::getClass()->manualChangeOrderStatus([
        ]);
    }

    /**
     * oms异常单列表
     *
     * @support  string $omsOrderNo 订单号 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOmsExceptionOrderList () {
        return self::getClass()->getOmsExceptionOrderList([
        ]);
    }

    /**
     * 修改订单支付方式
     *
     * @param  int $id 订单ID [ require true ]
     * @param  string $payType 支付方式 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changePayType (int $id, string $payType, string $paymentNo = '') {
        return self::getClass()->changePayType([
            "id" => $id,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
        ]);
    }

    /**
     * 根据订单id保存用户邮寄地址
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $expressInfo 物流信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addOrderAddress () {
        return self::getClass()->addOrderAddress([
        ]);
    }

    /**
     * 完成自提
     *
     * @support  int $itemId 订单itemId [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishExpress () {
        return self::getClass()->finishExpress([
        ]);
    }

    /**
     * 设置订单完成支付
     *
     * @param  float $money 订单金额 [ require true ]
     * @param  int $id 订单ID [ require true ]
     * @param  string $pay_type 支付类型 [ require true ]
     * @param  string $payment_no 支付流水号 [ require false ]
     * @param  string $certificate 支付凭证 [ require false ]
     * @param  string $payment_time 对公打款时间 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, float $money, string $pay_type, string $payment_no = '', string $certificate = '', string $payment_time = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "pay_type" => $pay_type,
            "payment_no" => $payment_no,
            "certificate" => $certificate,
            "payment_time" => $payment_time,
        ]);
    }

    /**
     * 发送零售业绩钉钉消息)
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function dingNotifyStaffEffect (int $id) {
        return self::getClass()->dingNotifyStaffEffect([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}