<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuThemeListByParams(array $params)
 * @method getThemeTemplateDetailByParams(array $params)
 * @method getAddPageSkuAndTemplateByParams(array $params)
 * @method getSkuTemplateWorkDetailByParams(array $params)
 */
class CustomizedV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品sku下所有主题数据
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeListDTO[]
     */
    public static function getSkuThemeList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSkuThemeList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeListDTO[]"
        );
    }

    /**
     * 获取sku的主题详情信息
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @support  int $themeId 产品主题Id [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeTemplateDetailDTO
     */
    public static function getThemeTemplateDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getThemeTemplateDetail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeTemplateDetailDTO"
        );
    }

    /**
     * 获取sku的加页增值服务，带增页模版信息
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @support  int $themeId 主题Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetAddPageSkuAndTemplateDTO
     */
    public static function getAddPageSkuAndTemplate () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAddPageSkuAndTemplate([
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetAddPageSkuAndTemplateDTO"
        );
    }

    /**
     * 获取当前sku模版和增值服务、贴图、背景数据信息
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @support  int $themeId 主题Id [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  int $orderItemId 订单子单id [ require false ]
     * @support  string $templateType 模版类型；书册封面：book_cover；相框类：photo_frame；书册内页：book_inner_page；书册logo页：book_logo_page； [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetSkuTemplateWorkDetailDTO
     */
    public static function getSkuTemplateWorkDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSkuTemplateWorkDetail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\GetSkuTemplateWorkDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Product\CustomizedV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Product\CustomizedV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}