<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hSetByParams(array $params)
 * @method hGetByParams(array $params)
 */
class Redis {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * Hash - hSet
     *
     * @support  string $key key [ require true ]
     * @support  string $field field [ require true ]
     * @support  string $value value [ require true ]
     * @support  int $ttl 租期时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function hSet () {
        return self::getClass()->hSet([
        ]);
    }

    /**
     * Hash - hGet
     *
     * @param  string $key key [ require true ]
     * @param  string $field field [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function hGet (string $key, string $field) {
        return self::getClass()->hGet([
            "key" => $key,
            "field" => $field,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Common\Redis');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Common\Redis');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}