<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method modifyOrderStaffIdByOrderNoByParams(array $params)
 * @method detailItemScatteredByParams(array $params)
 * @method detailItemAssociativeByParams(array $params)
 * @method listByParams(array $params)
 * @method timingReceivedOrderByParams(array $params)
 * @method orderListExportAddByParams(array $params)
 * @method detailByParams(array $params)
 * @method manualCreateProductOrderByParams(array $params)
 * @method manualChangeOrderStatusByParams(array $params)
 * @method getOmsExceptionOrderListByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据订单编号修改售出伙伴id
     *
     * @support  string $orderNo 零售订单号 [ require true ]
     * @support  int $inputStaffId 售出伙伴id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyOrderStaffIdByOrderNo () {
        return self::getClass()->modifyOrderStaffIdByOrderNo([
        ]);
    }

    /**
     * 商城订单-订单详情主表和子表不聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemScattered () {
        return self::getClass()->detailItemScattered([
        ]);
    }

    /**
     * 商城订单-订单详情主表和子表聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemAssociative () {
        return self::getClass()->detailItemAssociative([
        ]);
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $productOrderNo 生产单号 [ require false ]
     * @support  string $userName 用户名 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 后台手动收货
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function timingReceivedOrder () {
        return self::getClass()->timingReceivedOrder([
        ]);
    }

    /**
     * 订单列表导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数[userPhone:电话号码;orderNo:订单号;createTimeStart:创建开始时间;createTimeEnd:创建结束时间;status:状态;inputStaffId:录入人伙伴ID] [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function orderListExportAdd () {
        return self::getClass()->orderListExportAdd([
        ]);
    }

    /**
     * 零售订单详情
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 手动创建生成单
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualCreateProductOrder (int $id) {
        return self::getClass()->manualCreateProductOrder([
            "id" => $id,
        ]);
    }

    /**
     * 零售订单详情
     *
     * @support  string $status 状态;[生产中:produced;待收货:shipped;] [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  int $orderItemId 订单子单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function manualChangeOrderStatus () {
        return self::getClass()->manualChangeOrderStatus([
        ]);
    }

    /**
     * oms异常单列表
     *
     * @support  string $omsOrderNo 订单号 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOmsExceptionOrderList () {
        return self::getClass()->getOmsExceptionOrderList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}