<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createAddedProductByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $params)
 * @method updateAddedProductByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $params)
 * @method addedProductSkuBatchUpdateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $params)
 * @method bindAddedSkuListByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $params)
 */
class ProductV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建增值服务产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $createAddedProductCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\CreateAddedProductDTO
     */
    public static function createAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\CreateAddedProductCmd $createAddedProductCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createAddedProduct($createAddedProductCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\CreateAddedProductDTO"
        );
    }


    /**
     * 更新增值服务产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $updateAddedProductCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateAddedProduct (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\UpdateAddedProductCmd $updateAddedProductCmd) {
        return self::getClass()->updateAddedProduct($updateAddedProductCmd);
    }


    /**
     * 更新增值服务产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $addedProductSkuBatchUpdateCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addedProductSkuBatchUpdate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\AddedProductSkuBatchUpdateCmd $addedProductSkuBatchUpdateCmd) {
        return self::getClass()->addedProductSkuBatchUpdate($addedProductSkuBatchUpdateCmd);
    }


    /**
     * 更新增值服务产品
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $bindAddedSkuListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\BindAddedSkuListDTO
     */
    public static function bindAddedSkuList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Product\BindAddedSkuListCmd $bindAddedSkuListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindAddedSkuList($bindAddedSkuListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\BindAddedSkuListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\ProductV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\ProductV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}