<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAfterSaleItemsByOrderIdByParams(array $params)
 * @method getAfterSaleOrderDetailByParams(array $params)
 * @method createByParams(array $params)
 * @method closeByParams(array $params)
 * @method resubmitByParams(array $params)
 * @method getByOrderIdByParams(array $params)
 */
class AfterSale {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据订单id获取售后单AfterSaleItem信息
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAfterSaleItemsByOrderId (int $orderId) {
        return self::getClass()->getAfterSaleItemsByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 售后单创建页面 - 获取零售订单商品明细
     *
     * @support  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAfterSaleOrderDetail () {
        return self::getClass()->getAfterSaleOrderDetail([
        ]);
    }

    /**
     * 创建售后单
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $type 售后单类型 [ require true ]
     * @support  array $refundItemDetail 退款商品明细 [ require false ]
     * @support  string $reason 退款原因 [ require true ]
     * @support  string $note 退换货说明 [ require false ]
     * @support  int $confirmReturnInvoice 确认须退发票 [ require false ]
     * @support  float $money 退款金额 [ require false ]
     * @support  string $people 退款人 [ require false ]
     * @support  string $account 退款账户 [ require false ]
     * @support  int $isStaffPay 是否为伙伴垫付 [ require false ]
     * @support  array $staffPayCertificate 对公打款支付凭证图片地址 [ require false ]
     * @support  string $from 退款来源:user用户端， manager后台 [ require true ]
     * @support  int $inputStaffId 录入人伙伴ID [ require false ]
     * @support  int $createType 售后单创建方：1门店，2预约端 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 根据售后单id关闭售后单
     *
     * @param  int $id 退款ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $id) {
        return self::getClass()->close([
            "id" => $id,
        ]);
    }

    /**
     * 根据售后单id，重新提交售后单
     *
     * @support  int $id 售后单id [ require true ]
     * @support  string $people 退款人 [ require false ]
     * @support  string $account 退款账户 [ require false ]
     * @support  int $isStaffPay 是否为伙伴垫付 [ require false ]
     * @support  array $staffPayCertificate 对公打款支付凭证图片地址 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function resubmit () {
        return self::getClass()->resubmit([
        ]);
    }

    /**
     * 根据零售订单id获取零售 - 售后单
     *
     * @param  int $orderId 零售订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getByOrderId (int $orderId) {
        return self::getClass()->getByOrderId([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Store\Order\AfterSale');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Store\Order\AfterSale');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}