<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method batchCreateByParams(array $params)
 * @method listByParams(array $params)
 * @method listWithPaginatorByParams(array $params)
 * @method batchDeleteByParams(array $params)
 * @method photosPaginatorByParams(array $params)
 */
class UserImages {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户上传图片
     *
     * @support  array $images 图片数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreate () {
        return self::getClass()->batchCreate([
        ]);
    }

    /**
     * 用户图片列表-不分页
     *
     * @support  array $ids 图片ids [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 用户图片列表-分页
     *
     * @support  array $ids 图片ids [ require false ]
     * @support  int $page 第几页 [ require true ]
     * @support  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginator () {
        return self::getClass()->listWithPaginator([
        ]);
    }

    /**
     * 删除图片
     *
     * @param  array $ids 图片ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchDelete (array $ids) {
        return self::getClass()->batchDelete([
            "ids" => $ids,
        ]);
    }

    /**
     * 用户中心，我的照片列表-分页
     *
     * @support  array $ids 图片ids [ require false ]
     * @support  int $page 第几页 [ require true ]
     * @support  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function photosPaginator () {
        return self::getClass()->photosPaginator([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\UserImages');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\UserImages');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}