<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountCmd $params)
 * @method stopByParams(array $params)
 * @method detailByParams(array $params)
 * @method listWithPaginateByParams(array $params)
 * @method listByParams(array $params)
 * @method getNotStartAndInPorgressDiscountListByParams(array $params)
 * @method createDiscountMutexByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountMutexCmd $params)
 * @method updateDiscountMutexByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountMutexCmd $params)
 * @method deleteDiscountMutexByParams(array $params)
 * @method discountMutexListByParams(array $params)
 * @method checkProductSkuImportByParams(array $params)
 * @method exportAddByParams(array $params)
 */
class Discount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建促销活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountCmd $createDiscountCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountCmd $createDiscountCmd) {
        return self::getClass()->create($createDiscountCmd);
    }


    /**
     * 编辑促销活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountCmd $updateDiscountCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountCmd $updateDiscountCmd) {
        return self::getClass()->update($updateDiscountCmd);
    }


    /**
     * 终止促销活动
     *
     * @support  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stop () {
        return self::getClass()->stop([
        ]);
    }

    /**
     * 促销活动详情
     *
     * @param  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 促销活动列表
     *
     * @support  int $id 促销活动id [ require false ]
     * @support  array $ids 促销活动ids数组 [ require false ]
     * @support  int $levelId 活动层级id [ require false ]
     * @support  string $name 促销活动名称 [ require false ]
     * @support  string $status 促销活动状态:not_start未开始,in_progress进行中,ended已结束 [ require false ]
     * @support  string $type 活动类型：decrease打折；discount满减；pack打包一口价；markUpGift加价购 [ require false ]
     * @support  string $discountRelation 与其他活动的关系：share同享，exclusive排他，mutex互斥 [ require false ]
     * @support  array $storeIds 门店storeIds数组 [ require false ]
     * @support  bool $incluedeDiscountRule 是否包含discountRule信息 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginate () {
        return self::getClass()->listWithPaginate([
        ]);
    }

    /**
     * 促销活动列表
     *
     * @support  int $id 促销活动id [ require false ]
     * @support  array $ids 促销活动ids数组 [ require false ]
     * @support  int $levelId 活动层级id [ require false ]
     * @support  string $name 促销活动名称 [ require false ]
     * @support  string $status 促销活动状态:not_start未开始,in_progress进行中,ended已结束 [ require false ]
     * @support  string $type 活动类型：decrease打折；discount满减；pack打包一口价；markUpGift加价购 [ require false ]
     * @support  string $discountRelation 与其他活动的关系：share同享，exclusive排他，mutex互斥 [ require false ]
     * @support  array $storeIds 门店storeIds数组 [ require false ]
     * @support  bool $incluedeDiscountRule 是否包含discountRule信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 活动状态为：进行中、未开始的促销活动列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getNotStartAndInPorgressDiscountList () {
        return self::getClass()->getNotStartAndInPorgressDiscountList();
    }

    /**
     * 创建促销活动互斥关系
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountMutexCmd $createDiscountMutexCmd
     * @throws  \Exception
     * @return  array
     */
    public static function createDiscountMutex (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\CreateDiscountMutexCmd $createDiscountMutexCmd) {
        return self::getClass()->createDiscountMutex($createDiscountMutexCmd);
    }


    /**
     * 更新促销活动互斥关系
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountMutexCmd $updateDiscountMutexCmd
     * @throws  \Exception
     * @return  array
     */
    public static function updateDiscountMutex (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\UpdateDiscountMutexCmd $updateDiscountMutexCmd) {
        return self::getClass()->updateDiscountMutex($updateDiscountMutexCmd);
    }


    /**
     * 删除促销活动互斥关系
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteDiscountMutex () {
        return self::getClass()->deleteDiscountMutex();
    }

    /**
     * 展示所有已添加互斥关系的活动，且活动状态为：进行中、未开始
     *
     * @throws  \Exception
     * @return  array
     */
    public static function discountMutexList () {
        return self::getClass()->discountMutexList();
    }

    /**
     * 校验创建条件单时批量导入的productSku数据合法性
     *
     * @param  array $productSkus 需要被校验的productSkus [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function checkProductSkuImport (array $productSkus) {
        return self::getClass()->checkProductSkuImport([
            "productSkus" => $productSkus,
        ]);
    }

    /**
     * 导出某个渠道所有的sku简略信息
     *
     * @support  string $template_id 模板id:retail_promotion_product_sku_template [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportAdd () {
        return self::getClass()->exportAdd([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Discount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Discount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}