<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method modifyOrderStaffIdByOrderNoByParams(array $params)
 * @method detailItemScatteredByParams(array $params)
 * @method detailItemAssociativeByParams(array $params)
 * @method listByParams(array $params)
 * @method timingReceivedOrderByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据订单编号修改售出伙伴id
     *
     * @support  string $orderNo 零售订单号 [ require true ]
     * @support  int $inputStaffId 售出伙伴id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyOrderStaffIdByOrderNo () {
        return self::getClass()->modifyOrderStaffIdByOrderNo([
        ]);
    }

    /**
     * 订单详情主表和子表不聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemScattered () {
        return self::getClass()->detailItemScattered([
        ]);
    }

    /**
     * 订单详情主表和子表聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemAssociative () {
        return self::getClass()->detailItemAssociative([
        ]);
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 电话号码 [ require false ]
     * @support  string $orderNo 订单号 [ require false ]
     * @support  string $userName 用户名 [ require false ]
     * @support  string $createTimeStart 创建开始时间 [ require false ]
     * @support  string $createTimeEnd 创建结束时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  array $statusList 状态列表 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 后台手动收货
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function timingReceivedOrder () {
        return self::getClass()->timingReceivedOrder([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}