<?php
namespace Mainto\Bridge\Enums\ProjectRetail\Mall;

class OrderEnum {
    /**
     * 定制商城虚拟门店id
     */
    const MALL_ORDER_STORE_ID = 887;
    /**
     * 订单状态列表
     */
    const ORDER_STATUS_KEY_LIST = ['submitted' => '未支付','confirming' => '支付确认中','paid' => '已支付','produced' => '生产中','shipped' => '待收货','finished' => '已完成','closed' => '已关闭','after_sale_closed' => '售后关闭'];
    /**
     * 已完成:订单已经提货数量n（n=N）
     */
    const FINISHED = 'finished';
    /**
     * 包邮门槛价
     */
    const MAIL_FREE_MONEY = 88.0;
    /**
     * 快递偏远地区
     */
    const MAIL_REMOTE_AREAS = [0 => '海南省',1 => '内蒙古自治区',2 => '甘肃省',3 => '青海省',4 => '新疆维吾尔自治区',5 => '西藏自治区'];
    /**
     * 订单加急
     */
    const ORDER_URGENT = 'URGENT';
    /**
     * 快递商品名称
     */
    const MAIL_NAME = [0 => '普通快递',1 => '顺丰快递'];
    /**
     * 快递sku名称包邮
     */
    const MAIL_SKU_NAME_FREE = [0 => '顺丰快递',1 => '包邮'];
    /**
     * 快递sku名称
     */
    const MAIL_SKU_NAME = [0 => '顺丰快递',1 => '普通快递'];
    /**
     * 快递品牌名顺丰
     */
    const MAIL_BRAND_NAME_SHUNFENG = '顺丰';
    /**
     * 快递sku名称偏远
     */
    const MAIL_REMOTE_SKU_NAME = [0 => '普通快递偏远',1 => '顺丰快递偏远'];
    /**
     * 快递sku名称偏远[添加优惠券包邮]
     */
    const MAIL_REMOTE_COUPON_SKU_NAME = [0 => '包邮',1 => '顺丰快递偏远'];
    /**
     * 快递sku名称偏远
     */
    const MAIL_ALL_SKU_NAME = [0 => '普通快递偏远',1 => '顺丰快递偏远',2 => '顺丰快递',3 => '普通快递',4 => '包邮'];
    /**
     * 加急服务sku
     */
    const URGENT_SKU_NAME = [0 => '不加急',1 => '加急'];
    /**
     * 发货方式慢单
     */
    const SPEED_MODE_FES = 'FES';
    /**
     * 发货方式快单
     */
    const SPEED_MODE_FEP = 'FEP';
    /**
     * 自动确认收货天数周期 10天
     */
    const AUTO_RECEIVE_ORDER_DAY = 10;
}