<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listWithPaginatorByParams(array $params)
 * @method productOrderListExportAddByParams(array $params)
 * @method productOrderImagesExportAddByParams(array $params)
 * @method createLogisticsByParams(array $params)
 * @method batchCreateLogisticsByParams(array $params)
 */
class ProductOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生产订单列表-分页
     *
     * @support  int $id 生产订单id [ require false ]
     * @support  array $ids 生产订单ids [ require false ]
     * @support  string $orderNo 订单编号 [ require false ]
     * @support  string $productOrderNo 生产订单编号 [ require false ]
     * @support  string $status 状态，待制作、生产中、已发货 [ require false ]
     * @support  int $orderId 订单id [ require false ]
     * @support  array $orderIds 订单ids [ require false ]
     * @support  string $supplierCode 供应商code,方寸fangcun，寸心cunxin，泛太克fantaike [ require false ]
     * @support  int $export 导出次数 [ require false ]
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginator () {
        return self::getClass()->listWithPaginator([
        ]);
    }

    /**
     * 生产订单导出-直接通过接口
     *
     * @support  array $ids 生产订单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productOrderListExportAdd () {
        return self::getClass()->productOrderListExportAdd([
        ]);
    }

    /**
     * 生产订单图片导出
     *
     * @support  array $ids 生产订单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productOrderImagesExportAdd () {
        return self::getClass()->productOrderImagesExportAdd([
        ]);
    }

    /**
     * 单个生产订单批量绑定快递单号
     *
     * @support  string $productOrderNo 生产订单编号 [ require true ]
     * @support  array $logisticsNos 物流单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createLogistics () {
        return self::getClass()->createLogistics([
        ]);
    }

    /**
     * 多个生产订单批量绑定快递单号
     *
     * @support  array $data 生产订单和快递单信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchCreateLogistics () {
        return self::getClass()->batchCreateLogistics([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Order\ProductOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Order\ProductOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}