<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 */
class Refund {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 这里把oms同步过来的退款单给过滤掉
     *
     * @support  string $orderId 订单Id [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $applyTimeStart 申请时间-开始 [ require false ]
     * @support  string $applyTimeEnd 申请时间-结束 [ require false ]
     * @support  string $processTimeStart 处理时间-开始 [ require false ]
     * @support  string $processTimeEnd 处理时间-结束 [ require false ]
     * @support  array $froms 售后单来源:user用户，manager管理端, oms [ require false ]
     * @support  int $page 某一页 [ require false ]
     * @support  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Order\Refund');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Order\Refund');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}