<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSkuThemeListByParams(array $params)
 * @method getThemeTemplateDetailByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\UpdateCompositionDraftCmd $params)
 */
class CustomizedV2 {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建作品草稿
     *
     * @support  int $skuId 产品skuId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeListDTO[]
     */
    public static function getSkuThemeList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSkuThemeList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeListDTO[]"
        );
    }

    /**
     * 获取主题详情信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\UpdateCompositionDraftCmd $updateCompositionDraftCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeTemplateDetailDTO
     */
    public static function getThemeTemplateDetail (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\UpdateCompositionDraftCmd $updateCompositionDraftCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getThemeTemplateDetail($updateCompositionDraftCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Product\DTO\SkuThemeTemplateDetailDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Product\CustomizedV2');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Product\CustomizedV2');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}