<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentCmd $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listWithPaginateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListWithPaginateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListCmd $params)
 * @method createComponentItemByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentItemCmd $params)
 * @method updateComponentItemByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentItemCmd $params)
 * @method deleteComponentItemByParams(array $params)
 * @method componentItemListByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListCmd $params)
 * @method componentBindItemsByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindItemsCmd $params)
 * @method componentItemListWithPaginateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginateCmd $params)
 */
class CustomizedComponent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建组件包
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentCmd $createComponentCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentCmd $createComponentCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($createComponentCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO"
        );
    }


    /**
     * 更新模版组
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentCmd $updateComponentCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentCmd $updateComponentCmd) {
        return self::getClass()->update($updateComponentCmd);
    }


    /**
     * 组件包详情
     *
     * @param  int $id 模版组id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO"
        );
    }

    /**
     * 组件包详情
     *
     * @param  int $id 模版组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 组件包列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListWithPaginateCmd $componentListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentListWithPaginateDTO
     */
    public static function listWithPaginate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListWithPaginateCmd $componentListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithPaginate($componentListWithPaginateCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentListWithPaginateDTO"
        );
    }


    /**
     * 组件包列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListCmd $componentListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO[]
     */
    public static function list (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentListCmd $componentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($componentListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentDTO[]"
        );
    }


    /**
     * 创建模版组类目
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentItemCmd $createComponentItemCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemDTO
     */
    public static function createComponentItem (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateComponentItemCmd $createComponentItemCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createComponentItem($createComponentItemCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemDTO"
        );
    }


    /**
     * 更新模版组类目
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentItemCmd $updateComponentItem
     * @throws  \Exception
     * @return  bool
     */
    public static function updateComponentItem (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateComponentItemCmd $updateComponentItem) {
        return self::getClass()->updateComponentItem($updateComponentItem);
    }


    /**
     * 删除模版组类目
     *
     * @support  int $id 模版组类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteComponentItem () {
        return self::getClass()->deleteComponentItem([
        ]);
    }

    /**
     * 模版组类目列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListCmd $componentItemListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemDTO[]
     */
    public static function componentItemList (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListCmd $componentItemListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->componentItemList($componentItemListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemDTO[]"
        );
    }


    /**
     * 模版组类目列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindItemsCmd $componentBindItemsCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function componentBindItems (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentBindItemsCmd $componentBindItemsCmd) {
        return self::getClass()->componentBindItems($componentBindItemsCmd);
    }


    /**
     * 模版组类目列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemListWithPaginateDTO
     */
    public static function componentItemListWithPaginate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginateCmd $componentItemListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->componentItemListWithPaginate($componentItemListWithPaginateCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemListWithPaginateDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Customized\CustomizedComponent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Customized\CustomizedComponent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}