<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method changeStatusByParams(array $params)
 * @method listWithPaginateByParams(array $params)
 */
class SearchKeywords {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建热词
     *
     * @support  string $keyword 搜索关键字 [ require true ]
     * @support  int $sort 排序值 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 批量修改热词
     *
     * @support  array $data 搜索关键字更新/创建数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 删除热词
     *
     * @support  int $id 热词id [ require false ]
     * @support  array $ids 热词ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 热词列表
     *
     * @support  array $ids 热词ids [ require false ]
     * @support  string $status 状态：shelve启用，unshelve禁用 [ require false ]
     * @support  string $keyword 搜索关键字 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 热词启用
     *
     * @support  int $id 热词id [ require false ]
     * @support  array $ids 热词ids [ require false ]
     * @support  string $status 状态：shelve启用，unshelve禁用 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function changeStatus () {
        return self::getClass()->changeStatus([
        ]);
    }

    /**
     * 热词列表-分页
     *
     * @support  array $ids 热词ids [ require false ]
     * @support  string $status 状态：shelve启用，unshelve禁用 [ require false ]
     * @support  string $keyword 搜索关键字 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function listWithPaginate () {
        return self::getClass()->listWithPaginate([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\SearchKeywords');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\SearchKeywords');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}