<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CreateShopCartCmd $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method getListByParams(array $params)
 * @method getCountByParams(array $params)
 */
class ShopCart {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建购物车
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CreateShopCartCmd $createShopCartCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartSkuDTO[]
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CreateShopCartCmd $createShopCartCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($createShopCartCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartSkuDTO[]"
        );
    }


    /**
     * 修改购物车
     *
     * @support  array $products 购物车产品集合 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartSkuDTO[]
     */
    public static function update () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->update([
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartSkuDTO[]"
        );
    }

    /**
     * 删除购物车
     *
     * @support  array $ids 缓存ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 展示购物车
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartListDTO
     */
    public static function getList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList(),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\ShopCart\ShopCartListDTO"
        );
    }

    /**
     * 获取购物车商品条数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getCount () {
        return self::getClass()->getCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Order\ShopCart');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Order\ShopCart');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}