<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Order\Composition;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CompositionDraftCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\UpdateCompositionDraftCmd $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listWithPaginateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CompositionDraftListWithPaginatorCmd $params)
 */
class CompositionDraft {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建作品草稿
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CompositionDraftCmd $compositionDraftCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CompositionDraftCmd $compositionDraftCmd) {
        return self::getClass()->create($compositionDraftCmd);
    }


    /**
     * 更新作品草稿
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\UpdateCompositionDraftCmd $updateCompositionDraftCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\UpdateCompositionDraftCmd $updateCompositionDraftCmd) {
        return self::getClass()->update($updateCompositionDraftCmd);
    }


    /**
     * 作品草稿详情
     *
     * @param  int $id 草稿id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Order\DTO\CompositionDraftDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\CompositionDraftDTO"
        );
    }

    /**
     * 删除作品草稿
     *
     * @param  int $id 草稿id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 作品草稿列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CompositionDraftListWithPaginatorCmd $compositionDraftListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Order\DTO\CompositionDraftListWithPaginatorDTO
     */
    public static function listWithPaginate (\Mainto\Bridge\Structs\ProjectRetail\Order\Cmd\CompositionDraftListWithPaginatorCmd $compositionDraftListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithPaginate($compositionDraftListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Order\DTO\CompositionDraftListWithPaginatorDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Order\Composition\CompositionDraft');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Order\Composition\CompositionDraft');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}