<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Customized;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeCmd $params)
 * @method detailByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listWithPaginateByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListWithPaginateCmd $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListCmd $params)
 * @method groupListByParams(array $params)
 * @method createThemeGroupByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeGroupCmd $params)
 * @method updateThemeGroupByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeGroupCmd $params)
 * @method deleteThemeGroupByParams(array $params)
 * @method skuListWithPaginatorByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\SkuListWithPaginatorCmd $params)
 * @method templateListWithPaginatorByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\TemplateListWithPaginatorCmd $params)
 * @method componentItemListWithPaginatorByParams(array|\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginatorCmd $params)
 */
class CustomizedTheme {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建主题
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeCmd $createThemeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeCmd $createThemeCmd) {
        return self::getClass()->create($createThemeCmd);
    }


    /**
     * 更新主题
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeCmd $updateThemeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeCmd $updateThemeCmd) {
        return self::getClass()->update($updateThemeCmd);
    }


    /**
     * 主题详情
     *
     * @param  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO"
        );
    }

    /**
     * 专题删除
     *
     * @param  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 专题列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListWithPaginateCmd $themeListWithPaginateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeListWithPaginateDTO
     */
    public static function listWithPaginate (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListWithPaginateCmd $themeListWithPaginateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listWithPaginate($themeListWithPaginateCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeListWithPaginateDTO"
        );
    }


    /**
     * 专题列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListCmd $themeListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO[]
     */
    public static function list (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ThemeListCmd $themeListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($themeListCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeDTO[]"
        );
    }


    /**
     * 专题分组列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeGroupDTO[]
     */
    public static function groupList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->groupList(),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ThemeGroupDTO[]"
        );
    }

    /**
     * 创建专题分组
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeGroupCmd $createThemeGroupCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createThemeGroup (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\CreateThemeGroupCmd $createThemeGroupCmd) {
        return self::getClass()->createThemeGroup($createThemeGroupCmd);
    }


    /**
     * 更新专题分组
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeGroupCmd $updateThemeGroupCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateThemeGroup (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\UpdateThemeGroupCmd $updateThemeGroupCmd) {
        return self::getClass()->updateThemeGroup($updateThemeGroupCmd);
    }


    /**
     * 删除主题分组
     *
     * @support  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteThemeGroup () {
        return self::getClass()->deleteThemeGroup([
        ]);
    }

    /**
     * 创建主题筛选sku列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\SkuListWithPaginatorCmd $skuListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\SkuListWithPaginatorDTO
     */
    public static function skuListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\SkuListWithPaginatorCmd $skuListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->skuListWithPaginator($skuListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\SkuListWithPaginatorDTO"
        );
    }


    /**
     * 创建主题可用模版列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\TemplateListWithPaginatorCmd $templateListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\TemplateListWithPaginatorDTO
     */
    public static function templateListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\TemplateListWithPaginatorCmd $templateListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->templateListWithPaginator($templateListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\TemplateListWithPaginatorDTO"
        );
    }


    /**
     * 创建主题可用背景/贴图列表-分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginatorCmd $componentItemListWithPaginatorCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemsWithPaginatorDTO
     */
    public static function componentItemListWithPaginator (\Mainto\Bridge\Structs\ProjectRetail\Bms\Cmd\Customized\ComponentItemListWithPaginatorCmd $componentItemListWithPaginatorCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->componentItemListWithPaginator($componentItemListWithPaginatorCmd),
            "\Mainto\Bridge\Structs\ProjectRetail\Bms\DTO\Customized\ComponentItemsWithPaginatorDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Customized\CustomizedTheme');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Customized\CustomizedTheme');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}