<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method listByParams(array $params)
 * @method getAdjustPriceProductSkuListByParams(array $params)
 */
class Discount {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 促销活动详情
     *
     * @param  int $id 促销活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 促销活动列表
     *
     * @support  bool $incluedeDiscountRule 是否包含discountRule信息 [ require false ]
     * @support  bool $incluedeDiscountMetaData 是否包含discountMetaData信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 促销活动详情sku
     *
     * @support  array $ids skuIds数组 [ require true ]
     * @support  string $skuName skuName [ require false ]
     * @support  int $page page [ require true ]
     * @support  int $pageSize pageSize [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAdjustPriceProductSkuList () {
        return self::getClass()->getAdjustPriceProductSkuList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Store\Product\Discount');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Store\Product\Discount');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}