<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method productListWithPaginateByParams(array $params)
 * @method detailWithSkuByParams(array $params)
 * @method getProductByIdByParams(array $params)
 * @method getProductSkuByProductIdByParams(array $params)
 */
class ProductSell {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品列表
     *
     * @support  int $groupId 分组id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  int $type 产品类型 [ require false ]
     * @support  array $categoryIds 分类categoryId数组 [ require false ]
     * @support  string $productName 商品名称productName [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 产品列表-分页
     *
     * @support  int $groupId 分组id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  array $categoryIds 分类categoryIds数组 [ require false ]
     * @support  string $productName 商品名称productName [ require false ]
     * @support  bool $isOnlyShelve 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function productListWithPaginate () {
        return self::getClass()->productListWithPaginate([
        ]);
    }

    /**
     * 根据产品id获取产品和sku
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailWithSku (int $id) {
        return self::getClass()->detailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 根据产品id获取单个product
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductById (int $id) {
        return self::getClass()->getProductById([
            "id" => $id,
        ]);
    }

    /**
     * 根据产品id获取该产品所有的sku
     * @deprecated
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuByProductId (int $productId) {
        return self::getClass()->getProductSkuByProductId([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\ProductSell');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\ProductSell');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}