<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method listByParams(array $params)
 * @method copyProductSkuByParams(array $params)
 * @method updateProductSkuByParams(array $params)
 * @method shelveProductSkuByParams(array $params)
 * @method unshelveProductSkuByParams(array $params)
 * @method productSkuListWithoutPaginateByParams(array $params)
 * @method productListByParams(array $params)
 */
class SellChannel {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建渠道
     *
     * @support  string $name 渠道name [ require true ]
     * @support  string $code 渠道code [ require false ]
     * @support  int $isStoreSell 是否门店售卖 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 渠道列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 复制渠道商品sku
     *
     * @support  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @support  string $sellChannelSkuName 拍摄自定义的productSkuName别名 [ require false ]
     * @support  string $sellChannelSkuImage 拍摄自定义的productSkuImage图片 [ require false ]
     * @support  float $sellPrice 售价 [ require false ]
     * @support  float $settlementPrice 结算价格 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function copyProductSku () {
        return self::getClass()->copyProductSku([
        ]);
    }

    /**
     * 修改渠道商品sku
     *
     * @support  int $sellChannelProductSkuId 渠道商品productSkuId [ require true ]
     * @support  string $sellChannelCode 销售渠道类型：用于检验参数 [ require true ]
     * @support  string $sellChannelSkuName 拍摄自定义的productSkuName别名 [ require false ]
     * @support  string $sellChannelSkuImage 拍摄自定义的productSkuImage图片 [ require false ]
     * @support  string $outSkuCode 天猫有赞关联的 外部编码 [ require false ]
     * @support  float $sellPrice 售价 [ require false ]
     * @support  float $settlementPrice 结算价格 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProductSku () {
        return self::getClass()->updateProductSku([
        ]);
    }

    /**
     * 批量销售渠道上架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function shelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->shelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 批量销售渠道下架productSku
     *
     * @param  array $sellChannelProductSkuIds 销售渠道productSkuId数组 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unshelveProductSku (array $sellChannelProductSkuIds) {
        return self::getClass()->unshelveProductSku([
            "sellChannelProductSkuIds" => $sellChannelProductSkuIds,
        ]);
    }

    /**
     * 销售渠道productSku列表 - 分页
     *
     * @support  int $sellChannelId 销售渠道id [ require true ]
     * @support  array $categoryIds 销售渠道productSkuId数组 [ require false ]
     * @support  string $skuName 销售渠道skuName [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuListWithoutPaginate () {
        return self::getClass()->productSkuListWithoutPaginate([
        ]);
    }

    /**
     * 产品搜索查询-不分页
     *
     * @support  array $ids 渠道productId数组 [ require false ]
     * @support  int $type 1零售商品,2陈列商品,3定制商品,4商城定制商品 [ require false ]
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $groupId 商品分组id [ require false ]
     * @support  int $sellChannelId 销售渠道id [ require false ]
     * @support  bool $isOnlyShelveUp 默认上下架的sku都查，true查询上架的sku，false查询上架和下架的sku [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function productList () {
        return self::getClass()->productList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\SellChannel');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\SellChannel');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}