<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setProductStoreGroupByParams(array $params)
 * @method getStoreGroupBySkuIdByParams(array $params)
 * @method clearStoreGroupBySkuIdByParams(array $params)
 * @method deleteStoreGroupBySkuIdByParams(array $params)
 * @method addProductSkuStoreGroupByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method allByParams(array $params)
 */
class StoreGroup {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 设置零售商品售卖的门店或者门店组
     *
     * @param  array $ids 商品Ids [ require true ]
     * @param  array $storeGroupIds 门店组ids [ require false ]
     * @param  array $storeIds 门店ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function setProductStoreGroup (array $ids, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->setProductStoreGroup([
            "ids" => $ids,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 获取商品门店组信息
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoreGroupBySkuId (int $skuId) {
        return self::getClass()->getStoreGroupBySkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 清空商品skuId与门店、门店组关系
     *
     * @param  int $skuId skuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearStoreGroupBySkuId (int $skuId) {
        return self::getClass()->clearStoreGroupBySkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 删除商品与门店的关系
     *
     * @param  int $skuId 商品skuId [ require true ]
     * @param  array $storeIds 门店id列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteStoreGroupBySkuId (int $skuId, array $storeIds) {
        return self::getClass()->deleteStoreGroupBySkuId([
            "skuId" => $skuId,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 新增商品与门店组/门店管理
     *
     * @param  int $skuId 商品skuId [ require true ]
     * @param  array $storeGroupIds 门店组ids [ require false ]
     * @param  array $storeIds 门店ids [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addProductSkuStoreGroup (int $skuId, array $storeGroupIds = [], array $storeIds = []) {
        return self::getClass()->addProductSkuStoreGroup([
            "skuId" => $skuId,
            "storeGroupIds" => $storeGroupIds,
            "storeIds" => $storeIds,
        ]);
    }

    /**
     * 创建门店组
     *
     * @param  string $name 名称 [ require true ]
     * @param  string $remark 备注 [ require false ]
     * @param  array $rule 规则 [ require false ]
     * @param  array $whitelist 白名单 [ require false ]
     * @param  array $blacklist 黑名单 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return self::getClass()->create([
            "name" => $name,
            "remark" => $remark,
            "rule" => $rule,
            "whitelist" => $whitelist,
            "blacklist" => $blacklist,
        ]);
    }

    /**
     * 修改门店组
     *
     * @param  int $id id [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $remark 备注 [ require false ]
     * @param  array $rule 规则 [ require false ]
     * @param  array $whitelist 白名单 [ require false ]
     * @param  array $blacklist 黑名单 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, string $name, string $remark = '', array $rule = [], array $whitelist = [], array $blacklist = []) {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "remark" => $remark,
            "rule" => $rule,
            "whitelist" => $whitelist,
            "blacklist" => $blacklist,
        ]);
    }

    /**
     * 门店组列表
     *
     * @param  string $name 名称 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除门店组
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 获取全部门店组信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\StoreGroup');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\StoreGroup');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}