<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method listByParams(array $params)
 * @method createProductAndGroupBindingByParams(array $params)
 * @method batchCreateProductAndGroupBindingByParams(array $params)
 * @method updateProductAndGroupBindingByParams(array $params)
 * @method deleteProductAndGroupBindingByParams(array $params)
 * @method getProductAndGroupBindingByParams(array $params)
 */
class Group {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建分组
     *
     * @support  string $name 分组名称 [ require true ]
     * @support  string $imageUrl 分组图片 require false
     * @support  string $showPlace 展示位置index_list,index_banner require false
     * @support  int $sort 排序值 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新分组
     *
     * @support  int $id 分组id [ require true ]
     * @support  string $name 分组名称 [ require true ]
     * @support  string $imageUrl 分组图片 require false
     * @support  string $showPlace 展示位置index_list,index_banner require false
     * @support  int $sort 排序值 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除分组
     *
     * @param  int $id 分组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 分组列表
     *
     * @support  string $showPlace 展示位置index_list,index_banner require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 创建productId和groupId的绑定
     *
     * @support  int $groupId 分组id [ require true ]
     * @support  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function createProductAndGroupBinding () {
        return self::getClass()->createProductAndGroupBinding();
    }

    /**
     * 批量创建productId和groupId的绑定
     *
     * @support  int $groupId 分组id [ require true ]
     * @support  array $productInfo 产品和排序信息 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function batchCreateProductAndGroupBinding () {
        return self::getClass()->batchCreateProductAndGroupBinding();
    }

    /**
     * 更新productId和groupId的绑定
     *
     * @support  int $id id [ require true ]
     * @support  int $productId productId [ require true ]
     * @support  int $groupId 分组id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateProductAndGroupBinding () {
        return self::getClass()->updateProductAndGroupBinding();
    }

    /**
     * 删除productId和groupId的绑定
     *
     * @support  int $id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteProductAndGroupBinding () {
        return self::getClass()->deleteProductAndGroupBinding();
    }

    /**
     * 查询productId和groupId的绑定
     *
     * @support  int $id id require false
     * @support  array $ids ids require false
     * @support  int $groupId 分组id require false
     * @support  array $groupIds 分组ids require false
     * @support  int $productId 产品Id require false
     * @support  array $productIds 产品Ids require false
     * @throws  \Exception
     * @return  array
     */
    public static function getProductAndGroupBinding () {
        return self::getClass()->getProductAndGroupBinding();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Group');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Group');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}