<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCorrectTemplateListByParams(array $params)
 * @method getAppointOpenNumListByParams(array $params)
 */
class CustomizedTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 制作是获取定制模版列表
     *
     * @support  int $imgNum 图片数量 require false
     * @support  int $imgIds 图片ids require false
     * @support  int $productSkuId 商品skuId [ require true ]
     * @support  int $productOrderId 生产单id require false
     * @throws  \Exception
     * @return  array
     */
    public static function getCorrectTemplateList () {
        return self::getClass()->getCorrectTemplateList();
    }

    /**
     * 获取指定开孔数定制模版列表
     *
     * @support  int $openNum 图片数量 [ require true ]
     * @support  int $productSkuId 商品skuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAppointOpenNumList () {
        return self::getClass()->getAppointOpenNumList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\CustomizedTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\CustomizedTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}