<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createRandomByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method productSkuBatchCreateByParams(array $params)
 * @method productSkuBatchUpdateByParams(array $params)
 * @method productOnByParams(array $params)
 * @method productOffByParams(array $params)
 * @method productSkuShelveByParams(array $params)
 * @method productSkuUnshelveByParams(array $params)
 * @method productDisableByParams(array $params)
 * @method productEnableByParams(array $params)
 * @method productSkuDisableByParams(array $params)
 * @method productSkuEnableByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailWithSkuByParams(array $params)
 * @method getProductSkusByProductIdByParams(array $params)
 * @method allListByParams(array $params)
 * @method productSkuListByParams(array $params)
 * @method updateCustomizedTemplateByParams(array $params)
 * @method callbackOutSkuTemplateByParams(array $params)
 * @method callbackProductOrderItemByParams(array $params)
 * @method searchProductListByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 手动创建任务字符码
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function createRandom () {
        return self::getClass()->createRandom();
    }

    /**
     * 创建产品
     *
     * @support  int $type 1零售商品,2易耗品,3门店定制商品,4商城定制产品 [ require false ]
     * @support  int $categoryId 分类ID [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  array $newMainImage 商品主图 [ require false ]
     * @support  array $bannerUrl banner图 [ require false ]
     * @support  array $descriptionUrl 商品详情图 [ require false ]
     * @support  int $needCheckStock 是否需要盘点,0不需要要,1需要 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 更新产品
     *
     * @support  int $id 产品id [ require true ]
     * @support  int $type 1零售商品,2陈列商品,3定制商品 [ require false ]
     * @support  int $categoryId 分类ID [ require true ]
     * @support  int $groupId 分组ID [ require false ]
     * @support  string $name 产品名称 [ require true ]
     * @support  array $newMainImage 商品主图 [ require false ]
     * @support  array $bannerUrl banner图 [ require false ]
     * @support  array $descriptionUrl 商品详情图 [ require false ]
     * @support  bool $needCheckStock 是否需要盘点 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 批量创建productSku
     *
     * @support  int $productId 商品productId [ require true ]
     * @support  int $type 1零售商品,2易耗品,3门店定制商品,4商城定制产品 [ require true ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  array $productExtendMetric 商品productSku信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuBatchCreate () {
        return self::getClass()->productSkuBatchCreate([
        ]);
    }

    /**
     * 批量更新productSku
     *
     * @support  int $productId 商品productId [ require true ]
     * @support  int $type 1零售商品,2易耗品,3门店定制商品,4商城定制产品 [ require true ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  array $productSku 商品productSku信息 [ require true ]
     * @support  array $productExtendMetric 商品productSku信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuBatchUpdate () {
        return self::getClass()->productSkuBatchUpdate([
        ]);
    }

    /**
     * 上架product
     * @deprecated
     *
     * @param  int $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productOn (int $productId) {
        return self::getClass()->productOn([
            "productId" => $productId,
        ]);
    }

    /**
     * 下架product
     * @deprecated
     *
     * @param  int $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productOff (int $productId) {
        return self::getClass()->productOff([
            "productId" => $productId,
        ]);
    }

    /**
     * 上架productSku
     * @deprecated
     *
     * @param  int $productSkuId 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuShelve (int $productSkuId) {
        return self::getClass()->productSkuShelve([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * 下架productSku
     * @deprecated
     *
     * @param  int $productSkuId 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuUnshelve (int $productSkuId) {
        return self::getClass()->productSkuUnshelve([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * product停用
     *
     * @param  int $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productDisable (int $productId) {
        return self::getClass()->productDisable([
            "productId" => $productId,
        ]);
    }

    /**
     * product启用
     *
     * @param  int $productId 商品productId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productEnable (int $productId) {
        return self::getClass()->productEnable([
            "productId" => $productId,
        ]);
    }

    /**
     * productSku停用
     *
     * @param  int $productSkuId 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuDisable (int $productSkuId) {
        return self::getClass()->productSkuDisable([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * productSku启用
     *
     * @param  int $productSkuId 商品productSkuId [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function productSkuEnable (int $productSkuId) {
        return self::getClass()->productSkuEnable([
            "productSkuId" => $productSkuId,
        ]);
    }

    /**
     * 产品详情-不带sku
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-附带sku
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailWithSku (int $id) {
        return self::getClass()->detailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 根据productId获取下面所有的productSkus
     *
     * @support  int $productId 商品productId [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkusByProductId () {
        return self::getClass()->getProductSkusByProductId([
        ]);
    }

    /**
     * 产品搜索查询-不分页
     *
     * @support  int $type 1零售商品,2陈列商品,3定制商品,4商城定制商品 [ require false ]
     * @support  int $groupId 商品分组id [ require false ]
     * @support  string $name 名称(模糊查询) [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function allList () {
        return self::getClass()->allList([
        ]);
    }

    /**
     * 获取productSku-分页
     *
     * @support  int $id 商品productSKuId [ require false ]
     * @support  array $ids 商品productSKuIds [ require false ]
     * @support  int $productId 商品productId [ require false ]
     * @support  array $productIds 商品productIds [ require false ]
     * @support  array $status productSku状态 [ require false ]
     * @support  string $skuName sku_name模糊搜索 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuList () {
        return self::getClass()->productSkuList([
        ]);
    }

    /**
     * 上传sku模版psd
     *
     * @support  int $skuId productSku表的Id [ require true ]
     * @support  string $templatePath 模版图片 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCustomizedTemplate () {
        return self::getClass()->updateCustomizedTemplate([
        ]);
    }

    /**
     * sku模版回调
     *
     * @support  string $task_id 随机任务号 [ require true ]
     * @support  string $type 任务类型 [ require true ]
     * @support  string $out_path 目标存储路径 [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $fail_reason 状态为fail是携带 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function callbackOutSkuTemplate () {
        return self::getClass()->callbackOutSkuTemplate([
        ]);
    }

    /**
     * 用户作品回调
     *
     * @support  string $task_id 随机任务号 [ require true ]
     * @support  string $type 任务类型 [ require true ]
     * @support  string $out_path 目标存储路径 [ require true ]
     * @support  string $status 状态 [ require true ]
     * @support  string $fail_reason 状态为fail是携带 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function callbackProductOrderItem () {
        return self::getClass()->callbackProductOrderItem([
        ]);
    }

    /**
     * 产品搜索列表-各种条件的复杂查询
     *
     * @support  int $type 1零售商品,2陈列商品,3定制商品,4商城定制商品 [ require false ]
     * @support  array $types 1零售商品,2陈列商品,3定制商品,4商城定制商品 [ require false ]
     * @support  int $groupId 商品分组id [ require false ]
     * @support  string $name 名称(模糊查询) [ require false ]
     * @support  int $categoryId 分类ID [ require false ]
     * @support  array $categoryIds 分类ID列表 [ require false ]
     * @support  bool $isShowDisable 是否展示停用商品 [ require false ]
     * @support  array $status 状态 [ require false ]
     * @support  string $startAt 创建时间 [ require false ]
     * @support  string $endAt 更新时间 [ require false ]
     * @support  int $needCheckStock 是否需要盘点 [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 页内条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProductList () {
        return self::getClass()->searchProductList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}