<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserCouponsByParams(array $params)
 * @method bindCouponCodeByParams(array $params)
 * @method bindUserCouponsByParams(array $params)
 * @method getCouponBySceneByParams(array $params)
 * @method getSkuEffectiveCouponsByParams(array $params)
 * @method getCouponsListByIdsByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户中心获取用户优惠券
     *
     * @support  array $status 优惠券状态;已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserCoupons () {
        return self::getClass()->getUserCoupons();
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $code 优惠券状态;已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindCouponCode () {
        return self::getClass()->bindCouponCode();
    }

    /**
     * 根据不同场景绑定用户优惠卷
     *
     * @support  string $applyScene 应用场景 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindUserCoupons () {
        return self::getClass()->bindUserCoupons();
    }

    /**
     * 根据应用场景获取零售优惠券展示信息
     *
     * @support  string $applyScene 应用场景 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponByScene () {
        return self::getClass()->getCouponByScene();
    }

    /**
     * 获取Sku有效优惠券
     *
     * @support  array $products 订单故障信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuEffectiveCoupons () {
        return self::getClass()->getSkuEffectiveCoupons();
    }

    /**
     * 根据创建ids获取优惠券列表
     *
     * @support  array $ids 优惠券ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponsListByIds () {
        return self::getClass()->getCouponsListByIds();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}