<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method allByParams(array $params)
 */
class Supplier {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建供应商
     *
     * @support  string $name 名称 require false
     * @support  int $deliveryCycle 预计发货时间 require false
     * @support  string $code 供应商code [ require true ]
     * @support  string $domain 供应商域名 require false
     * @support  string $remark 备注 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改供应商
     *
     * @param  int $id id [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  int $deliveryCycle 预计发货时间 [ require true ]
     * @param  string $remark 备注 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id, string $name, int $deliveryCycle = 1, string $remark = '') {
        return self::getClass()->update([
            "id" => $id,
            "name" => $name,
            "deliveryCycle" => $deliveryCycle,
            "remark" => $remark,
        ]);
    }

    /**
     * 供应商列表
     *
     * @param  string $name 名称 [ require true ]
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页记录数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (string $name = '', int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "name" => $name,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 删除供应商
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 所有供应商[不分页]
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function all (string $name = '') {
        return self::getClass()->all([
            "name" => $name,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Supplier');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Supplier');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}