<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method productSkuListWithPaginateByParams(array $params)
 * @method productSkuDetailByParams(array $params)
 * @method getPromotionProductSkuByParams(array $params)
 * @method getProductSkuBySkuCodeByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售POS收银-productSku列表
     *
     * @support  array $categoryIds product分类数组 require false
     * @support  string $skuName 销售渠道skuName require false
     * @support  string $skuCode 销售渠道skuCode require false
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuListWithPaginate () {
        return self::getClass()->productSkuListWithPaginate();
    }

    /**
     * 零售POS收银-productSku详情
     *
     * @param  int $sellChannelProductSkuId 渠道的productSkuId [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuDetail (int $sellChannelProductSkuId) {
        return self::getClass()->productSkuDetail([
            "sellChannelProductSkuId" => $sellChannelProductSkuId,
        ]);
    }

    /**
     * 根据活动获取促销商品sku列表
     *
     * @support  int $promotionId 活动ID [ require true ]
     * @support  string $skuName 商品skuName require false
     * @support  int $isGiveaway 是否是赠品:0 否 1 是 require false
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPromotionProductSku () {
        return self::getClass()->getPromotionProductSku();
    }

    /**
     * 根据skuCode扫码获取productSku
     *
     * @param  string $skuCode sku编码/更多编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuBySkuCode (string $skuCode) {
        return self::getClass()->getProductSkuBySkuCode([
            "skuCode" => $skuCode,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Store\Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Store\Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}