<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Store\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $himo_order_id 拍摄订单号 require false
     * @support  int $user_id 用户ID require false
     * @support  string $user_name 用户名 require false
     * @support  string $user_phone 用户手机号 require false
     * @support  string $user_sex 用户性别 require false
     * @support  string $user_birthday 用户生日 require false
     * @support  float $money 订单金额(商品原价总额) [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后金额) [ require true ]
     * @support  float $original_money 订单金额(商品原价总额) [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $from 订单来源（pc:线下、mobile 线上） [ require true ]
     * @support  string $source 销售来源（onlineSales:线上预约端、offlineSales 线下门店、memberSales会员权益,customPlatform定制平台） [ require true ]
     * @support  string $note 备注 require false
     * @support  bool $is_staff 是否是内部员工 require false
     * @support  bool $use_staff_discount 是否使用员工优惠 require false
     * @support  int $input_staff_id 售出伙伴ID [ require true ]
     * @support  string $manager_discount_type 折扣类型 require false
     * @support  float $manager_discount_amount 折扣数值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 编辑订单
     *
     * @support  int $id 订单ID [ require true ]
     * @support  int $himo_order_id 拍摄订单号 require false
     * @support  int $store_id 门店ID [ require true ]
     * @support  int $user_id 用户ID require false
     * @support  string $user_name 用户名 require false
     * @support  string $user_phone 用户手机号 require false
     * @support  string $user_sex 用户性别 require false
     * @support  string $user_birthday 用户生日 require false
     * @support  float $money 订单金额(商品原价总额) [ require true ]
     * @support  float $real_money 订单实付金额(商品优惠之后金额) [ require true ]
     * @support  float $original_money 订单金额(商品原价总额) [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  string $from 订单来源（pc:线下、mobile 线上） [ require true ]
     * @support  string $source 销售来源（onlineSales:线上预约端、offlineSales 线下门店、memberSales会员权益,customPlatform定制平台） [ require true ]
     * @support  string $note 备注 require false
     * @support  bool $is_staff 是否是内部员工 require false
     * @support  bool $use_staff_discount 是否使用员工优惠 require false
     * @support  int $input_staff_id 售出伙伴ID [ require true ]
     * @support  string $manager_discount_type 折扣类型 require false
     * @support  float $manager_discount_amount 折扣数值 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Store\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Store\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}