<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method specListByParams(array $params)
 * @method getSkusByProductByParams(array $params)
 * @method getExpressUrgentListByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 产品分页列表
     *
     * @support  int $type 1零售商品，2陈列商品，3定制商品，4商城定制商品 require false
     * @support  string $name 名称(模糊查询) require false
     * @support  int $categoryId 分类ID require false
     * @support  array $categoryIds 分类ID列表 require false
     * @support  int $brandId 品牌ID require false
     * @support  array $status 状态 require false
     * @support  string $startAt 创建时间 require false
     * @support  int $onlineSales 预约端1/0 require false
     * @support  int $offlineSales 门店端1/0 require false
     * @support  int $needLabel 是否需要展示标签1/0 require false
     * @support  string $endAt 更新时间 require false
     * @support  int $isCombine 是否是组合商品 require false
     * @support  int $page 当前页 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 单位颜色列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function specList () {
        return self::getClass()->specList();
    }

    /**
     * 根据商品id获取对应的sku信息
     *
     * @param  int $id 商品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByProduct (int $id) {
        return self::getClass()->getSkusByProduct([
            "id" => $id,
        ]);
    }

    /**
     * 获取物流和加急服务数据
     *
     * @support  string $provinceName 省 [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExpressUrgentList () {
        return self::getClass()->getExpressUrgentList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}