<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userAddressesByParams(array $params)
 * @method userAddressCreateByParams(array $params)
 * @method userAddressUpdateByParams(array $params)
 * @method userAddressDeleteByParams(array $params)
 * @method addressTreeByParams(array $params)
 * @method detailByParams(array $params)
 * @method forgetUserPasswordByParams(array $params)
 * @method bindStaffIdByParams(array $params)
 * @method createWxMiniCodeByParams(array $params)
 * @method getUserIdsByStaffIdByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户收货地址查询
     *
     * @throws  \Exception
     * @return  array
     */
    public static function userAddresses () {
        return self::getClass()->userAddresses();
    }

    /**
     * 用户收货地址创建
     *
     * @support  string $name 用户姓名 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $cityId 城市ID [ require true ]
     * @support  int $provinceId 省ID [ require true ]
     * @support  int $districtId 区ID [ require true ]
     * @support  string $addressDetail 地址详情 [ require true ]
     * @support  bool $isDefaultAddress 是否是默认地址 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function userAddressCreate () {
        return self::getClass()->userAddressCreate();
    }

    /**
     * 用户收货地址更新
     *
     * @support  int $id 收货地址记录id [ require true ]
     * @support  string $name 用户姓名 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $cityId 城市ID [ require true ]
     * @support  int $provinceId 省ID [ require true ]
     * @support  int $districtId 区ID [ require true ]
     * @support  string $addressDetail 地址详情 [ require true ]
     * @support  bool $isDefaultAddress 是否是默认地址 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function userAddressUpdate () {
        return self::getClass()->userAddressUpdate();
    }

    /**
     * 用户收货地址删除
     *
     * @param  int $userAddressId 收货地址记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function userAddressDelete (int $userAddressId) {
        return self::getClass()->userAddressDelete([
            "userAddressId" => $userAddressId,
        ]);
    }

    /**
     * 获取省市区三级数据
     *
     * @throws  \Exception
     * @return  array
     */
    public static function addressTree () {
        return self::getClass()->addressTree();
    }

    /**
     * 用户详情
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * 通过手机号和短信验证码验证重置密码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPassword([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 用户id通过分销功能绑定员工id
     *
     * @support  int $staffId 员工id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bindStaffId () {
        return self::getClass()->bindStaffId();
    }

    /**
     * 通过员工token信息获取小程序二维码base64字符串
     *
     * @throws  \Exception
     * @return  string
     */
    public static function createWxMiniCode () {
        return self::getClass()->createWxMiniCode();
    }

    /**
     * 通过员工token信息获取绑定用户id列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserIdsByStaffId () {
        return self::getClass()->getUserIdsByStaffId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}