<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponCreateLogsByParams(array $params)
 * @method getTemplateListByParams(array $params)
 * @method abolishCouponsByParams(array $params)
 * @method getTemplateInfoByParams(array $params)
 * @method getCouponsByParams(array $params)
 * @method bulkGenerateCouponsByParams(array $params)
 * @method bindUserCouponsByParams(array $params)
 * @method createTemplateByParams(array $params)
 * @method templateUpdateByParams(array $params)
 * @method getAllSkuByTypeByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取优惠券创建列表
     *
     * @support  string $type 模板类型;折扣券:discount_coupon;立减券:decrease_coupon; require false
     * @support  string $applyIn 应用于业务;零售：retail require false
     * @support  int $page 页数 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponCreateLogs () {
        return self::getClass()->getCouponCreateLogs();
    }

    /**
     * 获取优惠券模版列表
     *
     * @support  string $type 优惠券类型;折扣券:discount_coupon;立减券:decrease_coupon;产品券:product_coupon; require false
     * @support  string $applyIn 应用于业务;零售：retail require false
     * @support  int $page 页数 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplateList () {
        return self::getClass()->getTemplateList();
    }

    /**
     * 作废优惠券
     *
     * @support  array $ids 优惠券IDs [ require true ]
     * @support  string $type 作废类型; [ require true ]
     * @support  array $extend 扩展信息; require false
     * @throws  \Exception
     * @return  bool
     */
    public static function abolishCoupons () {
        return self::getClass()->abolishCoupons();
    }

    /**
     * 查看模版详情
     *
     * @support  int $id 模板id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTemplateInfo () {
        return self::getClass()->getTemplateInfo();
    }

    /**
     * 查看优惠卷码详情
     *
     * @support  int $createLogId 创建记录id [ require true ]
     * @support  string $applyIn 应用于业务;零售：retail require false
     * @support  int $page 页数 require false
     * @support  int $pageSize 页内条数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getCoupons () {
        return self::getClass()->getCoupons();
    }

    /**
     * 创建优惠卷
     *
     * @support  int $count 创建数量 [ require true ]
     * @support  string $title 标题 [ require true ]
     * @support  int $userId 用户ID require false
     * @support  string $status 优惠券状态；已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; [ require true ]
     * @support  int $templateId 模板id [ require true ]
     * @support  string $buyChannel 购买渠道;门店团购：store_group;门店：store;BUSINESS事业部：business;总部：headquarters;个人：personal;天猫售出：tmall; [ require true ]
     * @support  float $discount 折扣｜立减金额 [ require true ]
     * @support  string $stopUsage 结束使用时间 [ require true ]
     * @support  string $startUsage 开始使用时间 [ require true ]
     * @support  array $logUniqueByFields 记录唯一 require false
     * @throws  \Exception
     * @return  array
     */
    public static function bulkGenerateCoupons () {
        return self::getClass()->bulkGenerateCoupons();
    }

    /**
     * 创建绑定单个用户优惠卷
     *
     * @support  int $count 创建数量[1~1000] [ require true ]
     * @support  string $title 标题[同一标题和模板id；表示相同优惠券] [ require true ]
     * @support  string $status 优惠券状态；已激活【已激活可能还未绑定】:activated;未使用:unused;使用:used;已作废:abolished;已过期:expired; require false
     * @support  int $templateId 模板id [ require true ]
     * @support  string $buyChannel 购买渠道;门店团购：store_group;门店：store;BUSINESS事业部：business;总部：headquarters;个人：personal;天猫售出：tmall; require false
     * @support  float $discount 折扣｜立减金额 [ require true ]
     * @support  string $stopUsage 结束使用时间 [ require true ]
     * @support  string $startUsage 开始使用时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function bindUserCoupons () {
        return self::getClass()->bindUserCoupons();
    }

    /**
     * 创建优惠券模版
     *
     * @support  string $name 优惠名称 [ require true ]
     * @support  string $type 优惠券类型;折扣券:discount_coupon;立减券:decrease_coupon;产品券:product_coupon; [ require true ]
     * @support  array $limit 优惠限制 require false
     * @support  string $applyIn 应用于业务 require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  int
     */
    public static function createTemplate () {
        return self::getClass()->createTemplate();
    }

    /**
     * 更新优惠券模版
     *
     * @support  int $id 模板id [ require true ]
     * @support  string $name 优惠名称 [ require true ]
     * @support  string $type 优惠券类型;折扣券:discount_coupon;立减券:decrease_coupon;产品券:product_coupon; [ require true ]
     * @support  array $limit 优惠限制 require false
     * @support  string $applyIn 应用于业务 require false
     * @support  array $extend 拓展信息 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function templateUpdate () {
        return self::getClass()->templateUpdate();
    }

    /**
     * 可用产品，所有零售商品列表
     *
     * @support  int $type 1零售商品,2陈列商品,3定制商品,4商城定制商品 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getAllSkuByType () {
        return self::getClass()->getAllSkuByType();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}