<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailByParams(array $params)
 * @method getEditorJumpParamsByParams(array $params)
 * @method setUserCompositionThumbnailByParams(array $params)
 * @method updateUserImageInfoByParams(array $params)
 * @method getOutTemplateBySkuIdByParams(array $params)
 * @method updateOriginalImageByParams(array $params)
 */
class ProductOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建生产订单
     *
     * @support  int $orderId 商城订单id [ require true ]
     * @support  int $orderItemId 商城订单明细id [ require true ]
     * @support  int $num 生产数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 生产订单详情
     *
     * @param  int $productOrderId 商城生产订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $productOrderId) {
        return self::getClass()->detail([
            "productOrderId" => $productOrderId,
        ]);
    }

    /**
     * 获取跳转寸心编辑器的参数信息
     *
     * @support  string $outOrderNo 第三方生产单标号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getEditorJumpParams () {
        return self::getClass()->getEditorJumpParams();
    }

    /**
     * 设置用户著作单作品缩略图
     *
     * @support  int $productOrderId 用户生产单id [ require true ]
     * @support  string $thumbnailUrl 用户作品缩略图url [ require true ]
     * @support  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setUserCompositionThumbnail () {
        return self::getClass()->setUserCompositionThumbnail();
    }

    /**
     * 上传用户作品图
     *
     * @support  int $productOrderItemId 定制生产子表id [ require true ]
     * @support  array $imageInfo 用户制作的图片详情 [ require true ]
     * @support  string $status 提交状态;草稿提交:draft;制作完成:complete; [ require true ]
     * @support  string $description 作品描述 require false
     * @support  string $name 作品名称 require false
     * @support  string $originImageUrl 原图url require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateUserImageInfo () {
        return self::getClass()->updateUserImageInfo();
    }

    /**
     * 通过skuid获取第三方模版数据
     *
     * @support  int $productSkuId 商品skuid [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getOutTemplateBySkuId () {
        return self::getClass()->getOutTemplateBySkuId();
    }

    /**
     * 上传用户制作原图
     *
     * @support  int $productOrderItemId 定制生产子表id require false
     * @support  array $images 上传原图 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function updateOriginalImage () {
        return self::getClass()->updateOriginalImage();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\ProductOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\ProductOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}