<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method detailItemScatteredByParams(array $params)
 * @method detailItemAssociativeByParams(array $params)
 * @method listByParams(array $params)
 * @method closeByUserByParams(array $params)
 * @method orderLogisticsByParams(array $params)
 * @method orderStatusConfirmingByParams(array $params)
 * @method setPaidByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售商城订单
     *
     * @support  int $userId 用户id require false
     * @support  string $userName 用户名 require false
     * @support  string $userPhone 用户手机号 require false
     * @support  string $userSex 用户性别 require false
     * @support  string $userBirthday 用户生日 require false
     * @support  float $money 订单金额(商品原价总额) [ require true ]
     * @support  float $originalMoney 订单的原价总额 [ require true ]
     * @support  float $realMoney 订单实付金额(商品优惠之后的总额) [ require true ]
     * @support  array $detail 订单详情 [ require true ]
     * @support  int $inputStaffId 售出伙伴ID require false
     * @support  string $note 备注 require false
     * @support  string $from 订单来源（pc:管理端、mobile:预约端, mall:微信商城小程序） [ require true ]
     * @support  string $source 销售来源（onlineSales:线上、offlineSales 线下、memberSales会员权益、gift赠品、customPlatform定制商城） require false
     * @support  array $couponIds 优惠券/产品券ids require false
     * @support  array $expressInfo 物流信息 require false
     * @support  array $shopCartIds 需要删除购物车ids require false
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 订单详情主表和子表不聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemScattered () {
        return self::getClass()->detailItemScattered();
    }

    /**
     * 订单详情主表和子表聚合
     *
     * @support  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemAssociative () {
        return self::getClass()->detailItemAssociative();
    }

    /**
     * 订单列表
     *
     * @support  string $userPhone 电话号码 require false
     * @support  string $orderNo 订单号 require false
     * @support  string $status 状态 require false
     * @support  array $statusList 状态列表 require false
     * @support  int $page 页数 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 用户手动关闭订单——未支付状态
     *
     * @support  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function closeByUser () {
        return self::getClass()->closeByUser();
    }

    /**
     * 订单物流信息
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $itemIds 订单明细ids require false
     * @throws  \Exception
     * @return  array
     */
    public static function orderLogistics () {
        return self::getClass()->orderLogistics();
    }

    /**
     * 设置订单状态是支付确认中
     *
     * @param  int $id 订单ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderStatusConfirming (int $id) {
        return self::getClass()->orderStatusConfirming([
            "id" => $id,
        ]);
    }

    /**
     * 设置订单完成支付-不走支付网关
     *
     * @param  int $id 订单id [ require true ]
     * @param  float $money 订单金额 [ require true ]
     * @param  string $payType 支付类型 [ require true ]
     * @param  string $paymentNo 支付流水号 [ require true ]
     * @param  string $certificate 支付凭证 [ require true ]
     * @param  string $paymentTime 对公打款时间 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function setPaid (int $id, float $money, string $payType, string $paymentNo = '', string $certificate = '', string $paymentTime = '') {
        return self::getClass()->setPaid([
            "id" => $id,
            "money" => $money,
            "payType" => $payType,
            "paymentNo" => $paymentNo,
            "certificate" => $certificate,
            "paymentTime" => $paymentTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}