<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Project;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStateByParams(array $params)
 * @method saveByParams(array $params)
 * @method historyByParams(array $params)
 * @method getSkuListByParams(array $params)
 */
class ProjectCollect {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店收集状态
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getState () {
        return self::getClass()->getState();
    }

    /**
     * 门店填写收集
     *
     * @param  int $project_id 计划ID [Original type uint] [ require true ]
     * @param  array $sku_info 关联sku [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function save (int $project_id, array $sku_info) {
        return self::getClass()->save([
            "project_id" => $project_id,
            "sku_info" => $sku_info,
        ]);
    }

    /**
     * 门店历史信息收集
     *
     * @support  string $name 名称(模糊查询) 
     * @support  int $page 当前页 [Original type uint] 
     * @support  int $pageSize 页内条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function history () {
        return self::getClass()->history();
    }

    /**
     * 计划包含的SKU
     *
     * @support  int $project_id 计划ID [Original type uint] [ require true ]
     * @support  string $skuName SKU名称(模糊查询) 
     * @support  int $categoryId 类目ID 
     * @support  int $page 当前页 [Original type uint] 
     * @support  int $pageSize 页内条数 [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuList () {
        return self::getClass()->getSkuList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Project\ProjectCollect');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Project\ProjectCollect');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}