<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method metricItemDeleteByParams(array $params)
 * @method listByParams(array $params)
 * @method allMetricsByParams(array $params)
 */
class Metric {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建规格
     *
     * @support  int $metricId 规格主表id [ require true ]
     * @support  array $itemList 规格详情 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改规格
     *
     * @support  int $id 规格id [ require true ]
     * @support  string $name 规格详情 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 删除规格
     *
     * @support  int $id 规格id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function metricItemDelete () {
        return self::getClass()->metricItemDelete();
    }

    /**
     * 规格列表
     *
     * @support  int $metricId 规格主表id [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 全部规格分类
     *
     * @support  string $showPlace 展示位置index_list,index_banner 
     * @throws  \Exception
     * @return  array
     */
    public static function allMetrics () {
        return self::getClass()->allMetrics();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Metric');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Metric');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}