<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method detailWithSkuByParams(array $params)
 * @method listByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3门店定制商品，4商城定制产品 [Original type uint] 
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $newMainImage 商品主图 
     * @support  array $bannerUrl banner图 
     * @support  array $descriptionUrl 商品详情图 
     * @support  int $needCheckStock 是否需要盘点,0不需要要，1需要 [Original type uint] 
     * @support  array $categoryAttrs 商品分类属性 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新产品
     *
     * @support  int $id 产品id [Original type uint] [ require true ]
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3定制商品 [Original type uint] 
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  int $groupId 分组ID [Original type uint] 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $newMainImage 商品主图 
     * @support  array $bannerUrl banner图 
     * @support  array $descriptionUrl 商品详情图 
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  array $categoryAttrs 商品分类属性 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 分组列表
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailWithSku (int $id) {
        return self::getClass()->detailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 分组列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}