<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\HimoOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getHimoOrderInfoByHimoOrderIdByParams(array $params)
 * @method getHimoOrderInfoByHimoOrderNoByParams(array $params)
 */
class HimoOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据拍摄订单id获取拍摄订单指定信息
     *
     * @param  int $himoOrderId 拍摄订单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHimoOrderInfoByHimoOrderId (int $himoOrderId) {
        return self::getClass()->getHimoOrderInfoByHimoOrderId([
            "himoOrderId" => $himoOrderId,
        ]);
    }

    /**
     * 根据拍摄订单编号获取拍摄订单指定信息
     *
     * @param  string $himoOrderNo 拍摄订单编号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getHimoOrderInfoByHimoOrderNo (string $himoOrderNo) {
        return self::getClass()->getHimoOrderInfoByHimoOrderNo([
            "himoOrderNo" => $himoOrderNo,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'HimoOrder\HimoOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'HimoOrder\HimoOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}