<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Bms\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method productSkuCreateByParams(array $params)
 * @method productSkuUpdateByParams(array $params)
 * @method productUpByParams(array $params)
 * @method productOffByParams(array $params)
 * @method productSkuUpByParams(array $params)
 * @method productSkuOffByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailWithSkuByParams(array $params)
 * @method getProductSkusByProductIdByParams(array $params)
 * @method listByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建产品
     *
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3门店定制商品，4商城定制产品 [Original type uint] 
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  string $name 产品名称 [ require true ]
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $newMainImage 商品主图 
     * @support  array $bannerUrl banner图 
     * @support  array $descriptionUrl 商品详情图 
     * @support  int $needCheckStock 是否需要盘点,0不需要要，1需要 [Original type uint] 
     * @support  array $categoryAttrs 商品分类属性 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新产品
     *
     * @support  int $id 产品id [Original type uint] [ require true ]
     * @support  int $isCombine 是否是组合商品 [Original type uint] [ require true ]
     * @support  int $type 1零售商品，2陈列商品，3定制商品 [Original type uint] 
     * @support  int $categoryId 分类ID [Original type uint] [ require true ]
     * @support  int $groupId 分组ID [Original type uint] 
     * @support  string $name 产品名称 [ require true ]
     * @support  int $brandId 品牌id [Original type uint] [ require true ]
     * @support  array $newMainImage 商品主图 
     * @support  array $bannerUrl banner图 
     * @support  array $descriptionUrl 商品详情图 
     * @support  bool $needCheckStock 是否需要盘点 [ require true ]
     * @support  array $categoryAttrs 商品分类属性 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 创建productSku
     *
     * @support  int $productId 商品productId [Original type uint] [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  array $metric 商品规格 [ require true ]
     * @support  string $image SKU图片 [ require true ]
     * @support  array $otherRelateCodes 其他编码 
     * @support  float $originalPrice 成本价（P1） [Original type double] [ require true ]
     * @support  float $franchiseePrice 加盟商价（P2） [Original type double] [ require true ]
     * @support  float $sellPrice 牌价（P3） [Original type double] [ require true ]
     * @support  string $sellChannel 销售渠道 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productSkuCreate () {
        return self::getClass()->productSkuCreate();
    }

    /**
     * 更新productSku
     *
     * @support  int $id 商品productSkuId [Original type uint] [ require true ]
     * @support  int $productId 商品productId [Original type uint] [ require true ]
     * @support  int $supplierId 供应商id [Original type uint] [ require true ]
     * @support  array $metric 商品规格 [ require true ]
     * @support  string $image SKU图片 [ require true ]
     * @support  array $otherRelateCodes 其他编码 
     * @support  float $originalPrice 成本价（P1） [Original type double] [ require true ]
     * @support  float $franchiseePrice 加盟商价（P2） [Original type double] [ require true ]
     * @support  float $sellPrice 牌价（P3） [Original type double] [ require true ]
     * @support  string $sellChannel 销售渠道 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuUpdate () {
        return self::getClass()->productSkuUpdate();
    }

    /**
     * 上架product
     *
     * @param  int $id 商品productId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productUp (int $id) {
        return self::getClass()->productUp([
            "id" => $id,
        ]);
    }

    /**
     * 下架product
     *
     * @param  int $id 商品productId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productOff (int $id) {
        return self::getClass()->productOff([
            "id" => $id,
        ]);
    }

    /**
     * 上架productSku
     *
     * @param  int $id 商品productSKuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuUp (int $id) {
        return self::getClass()->productSkuUp([
            "id" => $id,
        ]);
    }

    /**
     * 下架productSku
     *
     * @param  int $id 商品productSKuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function productSkuOff (int $id) {
        return self::getClass()->productSkuOff([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-不带sku
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 产品详情-附带sku
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailWithSku (int $id) {
        return self::getClass()->detailWithSku([
            "id" => $id,
        ]);
    }

    /**
     * 根据productId获取下面所有的productSkus
     *
     * @support  int $productId 商品productId [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkusByProductId () {
        return self::getClass()->getProductSkusByProductId();
    }

    /**
     * 分组列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Bms\Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Bms\Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}