<?php
namespace Mainto\Bridge\Invokes\ProjectRetail\Mall;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method userAddressesByParams(array $params)
 * @method userAddressCreateByParams(array $params)
 * @method userAddressUpdateByParams(array $params)
 * @method userAddressDeleteByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户收货地址查询
     *
     * @throws  \Exception
     * @return  array
     */
    public static function userAddresses () {
        return self::getClass()->userAddresses();
    }

    /**
     * 用户收货地址创建
     *
     * @support  string $name 用户姓名 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $cityId 城市ID [ require true ]
     * @support  int $provinceId 省ID [ require true ]
     * @support  int $districtId 区ID [ require true ]
     * @support  string $addressDetail 地址详情 [ require true ]
     * @support  bool $isDefaultAddress 是否是默认地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function userAddressCreate () {
        return self::getClass()->userAddressCreate();
    }

    /**
     * 用户收货地址更新
     *
     * @support  int $id 收货地址记录id [ require true ]
     * @support  string $name 用户姓名 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @support  int $cityId 城市ID [ require true ]
     * @support  int $provinceId 省ID [ require true ]
     * @support  int $districtId 区ID [ require true ]
     * @support  string $addressDetail 地址详情 [ require true ]
     * @support  bool $isDefaultAddress 是否是默认地址 
     * @throws  \Exception
     * @return  mixed
     */
    public static function userAddressUpdate () {
        return self::getClass()->userAddressUpdate();
    }

    /**
     * 用户收货地址删除
     *
     * @param  int $userAddressId 收货地址记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userAddressDelete (int $userAddressId) {
        return self::getClass()->userAddressDelete([
            "userAddressId" => $userAddressId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectRetail', 'Mall\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectRetail', 'Mall\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}